/****************************************************************************/
/* Ώۃ}CR R8C/38A                                                     */
/* ̧ٓe     Advanced}CRJ[mFvO                          */
/* o[W   Ver.1.04                                                    */
/* Date         2023.08.14                                                  */
/* Copyright    Wp}CRJ[[sψ                        */
/****************************************************************************/

/*
{vÓAAdvanced}CRJ[̊mFvOłB
*/

/*======================================*/
/* CN[h                         */
/*======================================*/
#include <stdio.h>
#include "sfr_r838a.h"                  /* R8C/38A SFR̒`t@C    */
#include "types3_beep.h"                /* TypeSuU[䃉Cu    */
#include "data_flash_lib.h"             /* f[^tbVCu   */
#include "printf_lib.h"                 /* printfgpCu         */

/*======================================*/
/* V{`                         */
/*======================================*/
/* 萔ݒ */
#define     ENCODER_1SOU    1   /* GR[_1Ȃ1  2Ȃ0ɂ */

#define     TRC_MOTOR_CYCLE 20000       /* O,EO[^PWM̎     */
                                        /* 50[ns] * 20000 = 1.00[ms]    */
#define     TRD_MOTOR_CYCLE 20000       /* ,E,ӰPWM̎   */
                                        /* 50[ns] * 20000 = 1.00[ms]    */

/* f[^tbV֘A  */
#define     DF_ADDR_START   0x3000      /* ݊JnAhX         */
#define     DF_ADDR_END     0x33ff      /* ݏIAhX         */

#define     DF_PARA_SIZE    32          /* DataFlashp[^        */

#define     DF_CHECK        0x00        /* DataFlash`FbN            */
#define     DF_INITCHECK    0x01        /* p[^`FbN     */
#define     DF_INITCHECK2   0x02        /* p[^`FbN2    */
#define     DF_SERVO_P      0x03        /* T[{Rg[ Pl       */
#define     DF_SERVO_D      0x04        /* T[{Rg[ Dl       */
#define     DF_DG_CORRECT   0x05        /* fW^␳             */
#define     DF_LIMIT_PWM    0x06        /* PWM~bg                  */
#define     DF_LIMIT_VR     0x07        /* {[~bg           */

/* ParameterChange֐p */
#define     BYTE            1           /* PoCg                     */
#define     WORD            2           /* QoCg                     */

/* DataFlash̃`FbNl */

/* DataFlash̏l     */
#define DF_CHECK_VALUE      0x23        /* ̒lႤȂ珉       */
#define DF_INITCHECK_VALUE  getCompileDay(__DATE__)     /*    */
#define DF_INITCHECK_VALUE2 getCompileMonth(__DATE__)   /*    */
#define DF_SERVO_P_VALUE    5           /* T[{Rg[ Pl       */
#define DF_SERVO_D_VALUE    10          /* T[{Rg[ Dl       */
#define DF_DG_CORRECT_VALUE 0           /* fW^␳             */
#define DF_LIMIT_PWM_VALUE  90          /* PWM~bg                  */
#define DF_LIMIT_VR_VALUE   60          /* {[~bg(~2{Ŏg)*/

/*======================================*/
/* vg^Cv錾                     */
/*======================================*/
void init( void );
unsigned char sensor_inp( void );
unsigned char center_inp( void );
unsigned char startbar_get( void );
unsigned char dipsw_get2( void );
unsigned char pushsw_get( void );
void led_out( unsigned char led );
void servoPwmOut( int pwm );
int getServoAngle( void );
int getAnalogSensor( void );
void servoControl( void );
void parameter_set( void );
void ParameterChange( signed char* DataAdr ,int Size ,
                              int Minimum ,int Maximum ,int Step ,int key);
void readDataFlashParameter( void );
void writeDataFlashParameter( void );
int getCompileMonth( const char *p );
int getCompileDay( const char *p );

/*======================================*/
/* O[oϐ̐錾                 */
/*======================================*/
int             pattern;                /* p^[ԍ                 */
unsigned long   cnt1;                   /* ^C}p                     */
int             iTimer10;               /* 10msJEgp               */

/* T[{֘A */
int             iSensorBefore;          /* ÕZTlۑ           */
int             iServoPwm;              /* T[{ovll               */
int             iAngle0;                /* SA/Dlۑ            */

/* [^hCuTypeS Ver.3LEDAfBbvXCb` */
unsigned char   types_led;              /* LEDlݒ                    */
unsigned char   types_dipsw;            /* fBbvXCb`lۑ       */

/* f[^tbV֘A */
signed char     data_buff[ DF_PARA_SIZE ];  /* ꎞۑGA           */

/* GR[_֘A */
int             iTimer10;               /* 10msJEgp               */
long            lEncoderTotal;          /* ώZlۑp                 */
int             iEncoder;               /* 10ms̍ŐVl               */
unsigned int    uEncoderBuff;           /* vZp@荞ݓŎgp     */

/* ⓹op */
int             saka0_ad;               /* n̍⓹{[A/Dl    */
int             saka;

/************************************************************************/
/* CvO                                                     */
/************************************************************************/
void main( void )
{
    /* }CR@\̏ */
    init();                             /*                        */
    asm(" fset I ");                    /* Ŝ̊荞݋           */
    initBeepS();                        /* uU[֘A               */
    init_uart0_printf( SPEED_9600 );
    printf( "\033[H" );                 // ʃNA
    printf( "\033[2J" );

    /* }CRJ[̏ԏ */
    servoPwmOut( 0 );
    setBeepPatternS( 0x8000 );

    /* f[^tbV */
    readDataFlashParameter();           /* DataFlashp[^ǂݍ  */

    
    cnt1 = 0;
    while( cnt1 <= 10 );
    iAngle0  = getServoAngle();         /* ݂̃XeAOpx0xɂ */
    saka0_ad = ad4;                     /* ݂̍⓹{[lOƂ@*/

    while( 1 ) {

    switch( pattern ) {
    case 0:
        /* ݒAmF */
        parameter_set();

        /* vbVXCb``FbN */
        if( pushsw_get() ) {
            led_out( 0x3 );
            /* ۑ  */
            writeDataFlashParameter();
            setBeepPatternS( 0xcc00 );
            led_out( 0x0 );
            pattern = 1;
            cnt1 = 0;
            break;
        }
        break;

    case 1:
        /* 0.5s҂ */
        if( cnt1 >= 500 ) {
            pattern = 11;
            cnt1 = 0;
        }
        break;

    case 11:
        /* AiOZTɂT[{ */
        servoPwmOut( iServoPwm );

        /* XCb`ꂽI */
        if( pushsw_get() ) {
            led_out( 0x0 );
            setBeepPatternS( 0xcc00 );
            servoPwmOut( 0 );
            pattern = 91;
            cnt1 = 0;
            break;
        }

        /* LED_ŏ */
        if( cnt1 < 50 ) {
            led_out( 0x1 );
        } else if( cnt1 < 100 ) {
            led_out( 0x2 );
        } else {
            cnt1 = 0;
        }

        break;

    case 91:
        /* I */
        if( cnt1 >= 500 ) {
            pattern = 0;
            cnt1 = 0;
        }
        break;

    default:
        break;
    }
    }
}

/************************************************************************/
/* R8C/38A XyVt@NVWX^(SFR)̏                */
/************************************************************************/
void init( void )
{
    int     i;

    /* NbNXINNbN(20MHz)ɕύX */
    prc0  = 1;                          /* veNg               */
    cm13  = 1;                          /* P4_6,P4_7XIN-XOUT[qɂ*/
    cm05  = 0;                          /* XINNbNU              */
    for(i=0; i<50; i++ );               /* 肷܂ŏ҂(10ms) */
    ocd2  = 0;                          /* VXeNbNXINɂ  */
    prc0  = 0;                          /* veNgON                 */

    /* |[g̓o͐ݒ */

    /*  PWM(\)       OM_PMW       EOM_PWM       uU[
        ZT[      ZT      ZTE      ZTE[  */
    p0   = 0x00;
    prc2 = 1;                           /* PD0̃veNg          */
    pd0  = 0xf0;

    /*  ZTS      ް         RxD0            TxD0
        DIPSW3          DIPSW2          DIPSW1          DIPSW0          */
    pur0 |= 0x04;                       /* P1_3`P1_0̃vAbvON     */
    p1  = 0x00;
    pd1 = 0x10;

    /*  EOM_      XeAM_    XeAM_PWM     EM_PWM
        EM_      M_PWM       M_      OM_      */
    p2  = 0x00;
    pd2 = 0xff;

    /*  none            none            none            none
        none            none            none            GR[_A   */
    p3  = 0x00;
    pd3 = 0xfa;

    /*  XOUT            XIN             {[hLED   none
        none            VREF            none            none            */
    p4  = 0x20;                         /* P4_5LED:͓_         */
    pd4 = 0xb8;

    /*  none            none            none            none
        none            none            none            none            */
    p5  = 0x00;
    pd5 = 0xff;

    /*  none            none            none            none
        none            none            none            none            */
    p6  = 0x00;
    pd6 = 0xff;

    /*  CN6.2       CN6.3       CN6.4       CN6.5
        none(۸ޗ\) pxVR          ZT_۸  ZT_E۸  */
    p7  = 0x00;
    pd7 = 0x00;

    /*  DIPSWorLED      DIPSWorLED      DIPSWorLED      DIPSWorLED
        DIPSWorLED      DIPSWorLED      DIPSWorLED      DIPSWorLED      */
    pur2 |= 0x03;                       /* P8_7`P8_0̃vAbvON     */
    p8  = 0x00;
    pd8 = 0x00;

    /*  -               -               ߯       P8(LEDorSW)
        EOM_Free      OM_Free      EM_Free      M_Free      */
    pu23 = 1;                           /* P9_4,P9_5vAbv    */
    p9  = 0x00;
    pd9 = 0x1f;

    /* ^C}RB̐ݒ */
    /* 荞ݎ = 1 / 20[MHz]   * (TRBPRE+1) * (TRBPR+1)
                    = 1 / (20*10^6) * 200        * 100
                    = 0.001[s] = 1[ms]
    */
    trbmr  = 0x00;                      /* 샂[hAݒ       */
    trbpre = 200-1;                     /* vXP[WX^         */
    trbpr  = 100-1;                     /* vC}WX^           */
    trbic  = 0x06;                      /* 荞ݗD惌xݒ       */
    trbcr  = 0x01;                      /* JEgJn                 */

    /* A/DRo[^̐ݒ */
    admod   = 0x33;                     /* JԂ|[hɐݒ     */
    adinsel = 0xb0;                     /* ͒[qP78[qI      */
    adcon1  = 0x30;                     /* A/D\                  */
    asm(" nop ");                       /* AD1TCNEGCg*/
    adcon0  = 0x01;                     /* A/DϊX^[g              */

    /* ^C}RD ZbgPWM[hݒ(ӰAEӰAӰ) */
    trdpsr0 = 0x08;                     /* TRDIOB0,C0,D0[qݒ        */
    trdpsr1 = 0x05;                     /* TRDIOA1,B1,C1,D1[qݒ     */
    trdmr   = 0xf0;                     /* obt@WX^ݒ         */
    trdfcr  = 0x01;                     /* ZbgPWM[hɐݒ  */
    trdcr0  = 0x20;                     /* \[XJEg̑I:f1      */
    trdgra0 = trdgrc0 = TRD_MOTOR_CYCLE - 1;    /* ݒ             */
    trdgrb0 = trdgrd0 = 0;              /* P2_2[qON(ヂ[^)   */
    trdgra1 = trdgrc1 = 0;              /* P2_4[qON(Eヂ[^)   */
    trdgrb1 = trdgrd1 = 0;              /* P2_5[qON(T[{[^) */
    trdoer1 = 0xcd;                     /* o͒[q̑I               */
    trdstr  = 0x0d;                     /* TRD0JEgJn             */

    // ^C}RG [^GR[_̃pXJEgp
#if ENCODER_1SOU // 1Ȃ1 2Ȃ0ɂ
    tstart_trgmr = 0;                   /* TRG̃JEg~            */
    timsr = 0x40;                       /* TRGCLKA[q P3_0Ɋ蓖Ă */
    trgcr = 0x15;                       /* TRGCLKA[q̗GbWŃJEg*/
    trgmr = 0x80;                       /* TRG̃JEgJn            */
#else
    tstart_trgmr = 0;                   /* TRG̃JEg~            */
    timsr = 0xc0;                       /* TRGCLKA[qP3_0,           */
                                        /*   TRGCLKB[qP3_2Ɋ蓖*/
    trgcntc = 0xff;                     /* ʑvӰނ̶ĕ@w   */
    trgmr = 0x82;                       /* TRG̃JEgJn            */
#endif
}

/************************************************************************/
/* ^C}RB 荞ݏ                                                */
/************************************************************************/
#pragma interrupt /B intTRB(vect=24)
void intTRB( void )
{
    unsigned int    i;

    asm(" fset I ");                    /* ^C}RBȏ̊荞݋   */

    cnt1++;

    /* T[{[^ */
    servoControl();

    /* uU[ */
    beepProcessS();

    /* 101s鏈 */
    iTimer10++;
    switch( iTimer10 ) {
    case 1:
        /* GR[_ */
        i = trg;
        iEncoder       = i - uEncoderBuff;
        lEncoderTotal += iEncoder;
        uEncoderBuff = i;
        break;

    case 2:
        /* XCb`ǂݍݏ */
        p9_4 = 0;                       /* LEDoOFF                   */
        pd8  = 0x00;
        break;

    case 3:
        /* XCb`ǂݍ݁ALEDo */
        types_dipsw = ~p8;              /* ײފTypeS Ver.3SWǂݍ*/
        p8  = types_led;                /* ײފTypeS Ver.3LED֏o*/
        pd8 = 0xff;
        p9_4 = 1;                       /* LEDoON                    */
        break;

    case 4:
        break;

    case 5:
        break;

    case 6:
        break;

    case 7:
        break;

    case 8:
        break;

    case 9:
        break;

    case 10:
        /* iTimer10ϐ̏ */
        iTimer10 = 0;
        break;
    }
}

/************************************************************************/
/* AiOZTTypeS̃fW^ZTlǂݍ                    */
/* @ Ȃ                                                          */
/* ߂l [AAEAE[̃fW^ZT 0: 1:              */
/************************************************************************/
unsigned char sensor_inp( void )
{
    unsigned char sensor;

    sensor = ~p0 & 0x0f;

    return sensor;
}

/************************************************************************/
/* AiOZTTypeS Ver.2̒SfW^ZTǂݍ            */
/* @ Ȃ                                                          */
/* ߂l SfW^ZT 0: 1:                                  */
/************************************************************************/
unsigned char center_inp( void )
{
    unsigned char sensor;

    sensor = ~p1_7 & 0x01;

    return sensor;
}

/************************************************************************/
/* AiOZTTypeS Ver.2̃X^[go[oZTǂݍ        */
/* @ Ȃ                                                          */
/* ߂l 0:X^[go[Ȃ 1:X^[go[                         */
/************************************************************************/
unsigned char startbar_get( void )
{
    unsigned char sensor;

    sensor = ~p1_6 & 0x01;

    return sensor;
}

/************************************************************************/
/* [^hCuTypeS Ver.3̃fBbvXCb`lǂݍ          */
/* @ Ȃ                                                          */
/* ߂l XCb`l 0`255                                             */
/************************************************************************/
unsigned char dipsw_get2( void )
{
    /* ۂ̓͂̓^C}RB荞ݏŎ{ */
    return types_dipsw;
}

/************************************************************************/
/* [^hCuTypeS Ver.3̃vbVXCb`lǂݍ          */
/* @ Ȃ                                                          */
/* ߂l XCb`l 0:OFF 1:ON                                         */
/************************************************************************/
unsigned char pushsw_get( void )
{
    unsigned char sw;

    sw = ~p9_5 & 0x01;

    return sw;
}

/************************************************************************/
/* [^hCuTypeS Ver.3LED                               */
/* @ 8LED 0:OFF 1:ON                                       */
/* ߂l Ȃ                                                          */
/************************************************************************/
void led_out( unsigned char led )
{
    /* ۂ̏o͂̓^C}RB荞ݏŎ{ */
    types_led = led;
}

/************************************************************************/
/* T[{[^                                                     */
/* @ T[{[^PWMF-100`100                                    */
/*        0Œ~A100Ő]100%A-100ŋt]100%                        */
/* ߂l Ȃ                                                          */
/************************************************************************/
void servoPwmOut( int pwm )
{
    /* {[lɂ荶~bg */
    if( getServoAngle() >= data_buff[DF_LIMIT_VR] * 2 ) {
        if( pwm < -10 ) pwm = 0;
    }
    /* {[lɂE~bg */
    if( getServoAngle() <= -data_buff[DF_LIMIT_VR] * 2 ) {
        if( pwm >  10 ) pwm = 0;
    }

    if( pwm >= 0 ) {
        p2_6 = 0;
        trdgrd1 = (long)( TRD_MOTOR_CYCLE - 2 ) * pwm / 100;
    } else {
        p2_6 = 1;
        trdgrd1 = (long)( TRD_MOTOR_CYCLE- 2 ) * ( -pwm ) / 100;
    }
}

/************************************************************************/
/* T[{px擾                                                       */
/* @ Ȃ                                                          */
/* ߂l ւ̒l                                                */
/************************************************************************/
int getServoAngle( void )
{
    return( ad2 - iAngle0 );
}

/************************************************************************/
/* AiOZTl擾                                                 */
/* @ Ȃ                                                          */
/* ߂l ZTl                                                      */
/************************************************************************/
int getAnalogSensor( void )
{
    static int iSensorPattern = 0;      /* ZTԕێp             */
    int ret;

    ret = ad1 - ad0;                    /* AiOZT擾       */

    if( data_buff[DF_DG_CORRECT] ) {
        /* NN[hłȂΕ␳ */
        switch( iSensorPattern ) {
        case 0:
            if( sensor_inp() == 0x04 ) {
                ret = -700;
                break;
            }
            if( sensor_inp() == 0x02 ) {
                ret = 700;
                break;
            }
            if( sensor_inp() == 0x0c ) {
                ret = -800;
                iSensorPattern = 1;
                break;
            }
            if( sensor_inp() == 0x03 ) {
                ret = 800;
                iSensorPattern = 2;
                break;
            }
            break;

        case 1:
            /* ZTE */
            ret = -800;
            if( sensor_inp() == 0x04 ) {
                iSensorPattern = 0;
            }
            break;

        case 2:
            /* ZT */
            ret = 800;
            if( sensor_inp() == 0x02 ) {
                iSensorPattern = 0;
            }
            break;
        }
    }

    return ret;
}

/************************************************************************/
/* T[{[^                                                     */
/* @ Ȃ                                                          */
/* ߂l O[oϐ iServoPwm ɑ                               */
/************************************************************************/
void servoControl( void )
{
    int i, iRet, iP, iD;

    i = getAnalogSensor();              /* ZTl擾                 */

    /* T[{[^pPWMlvZ */
    iP = data_buff[DF_SERVO_P] * i;                    /*           */
    iD = data_buff[DF_SERVO_D] * (iSensorBefore - i ); /*           */
    iRet = iP - iD;
    iRet /= 64;

    /* PWM̏̐ݒ */
    if( iRet > data_buff[DF_LIMIT_PWM] )
        iRet = data_buff[DF_LIMIT_PWM]; /* }CRJ[肵     */
    if( iRet < -data_buff[DF_LIMIT_PWM] )
        iRet = -data_buff[DF_LIMIT_PWM];/* 90炢ɂĂ */
    iServoPwm = iRet;

    iSensorBefore = i;                  /* ͂̒l1msO̒lƂȂ*/
}

/************************************************************************/
/* p[^                                                       */
/*                                                                  */
/* ߂l                                                               */
/************************************************************************/
void parameter_set( void )
{
    static int  mode = 1;
    static int  push_pop;
    static signed char ret;
    char        c;

    if( data_buff[DF_INITCHECK] != DF_INITCHECK_VALUE ||
                data_buff[DF_INITCHECK2] != DF_INITCHECK_VALUE2 ) {
        data_buff[DF_INITCHECK]  = DF_INITCHECK_VALUE;
        data_buff[DF_INITCHECK2] = DF_INITCHECK_VALUE2;
        mode = 91;
    }

    switch( mode ) {
    case 1:
        /* j[ */
        printf( "\n" );
        printf( "Advanced MicomCar mF\n" );
        printf( "\n" );
        printf( " 0 : eZTl̊mF\n" );
        printf( " 1 : AiOZTl̊mF(fW^␳Ȃ)\n" );
        printf( " 2 : AiOZTl̊mF(fW^␳)\n" );
        printf( " 3 : AiOZTgPD\n" );
        printf( " 4 : PWMl̃~bg\n" );
        printf( " 5 : {[l̃~bg\n" );
        printf( " 6 : ZT[o[pxop{[l̊mF\n" );
        printf( " 7 : ݒl̕ۑ\n" );
        printf( " 8 : ݒl̏\n" );
        printf( "\n" );
        printf( "0`8̐͂Ă@" );
        mode = 2;
        break;

    case 2:
        /* ̓ */
        if( get_uart0(&c) ) {
           if( c >= '0' && c <= '8' ) {
                printf( "%c\n\n" , c );
                cnt1 = 0;
                if( c == '0' ) {
                    mode = 101;
                } else {
                    mode = (c - 0x30) * 10 + 1;
                }
            }
        }
        break;

    case 11:
        /* AiOZTl̊mFifW^␳Ȃj */
        printf( " AiOZTl̊mF(fW^␳Ȃ)\n" );
        printf( "   ( ێ : Space    I : Enter )\n\n" );
        /* ޔ */
        push_pop = data_buff[DF_DG_CORRECT];
        cnt1 = 0;
        mode = 12;
        break;

    case 12:
        data_buff[DF_DG_CORRECT] = 0;
        /* ʍXV10ms */
        if( cnt1 > 10 ){
            printf( "   L =%4d  R =%4d  L-R =%+05d \r", ad1, ad0, getAnalogSensor() );
            cnt1 = 0;
        }
        if( get_uart0(&c) ){
            if(  c == ' ' ){
                mode = 13;
            }
            else if(  c == 0x0d ){
                /* A */
                data_buff[DF_DG_CORRECT] = push_pop;
                mode = 1;
            }
        }
        break;

    case 13:
        if( get_uart0(&c) ){
            if(  c == ' ' ){
                mode = 12;
            }
            else if(  c == 0x0d ){
                /* A */
                data_buff[DF_DG_CORRECT] = push_pop;
                mode = 1;
            }
        }
        break;

    case 21:
        /* AiOZTl̊mFifW^␳j */
        printf( " AiOZTl̊mF(fW^␳)\n" );
        printf( "   ( ێ : Space    I : Enter )\n\n" );
        /* ޔ */
        push_pop = data_buff[DF_DG_CORRECT];
        cnt1 = 0;
        mode = 22;
        break;

    case 22:
        data_buff[DF_DG_CORRECT] = 1;
        /* ʍXV10ms */
        if( cnt1 > 10 ){
            printf( "   L =%4d  R =%4d  L-R =%+05d \r", ad1, ad0, getAnalogSensor() );
            cnt1 = 0;
        }
        if( get_uart0(&c) ){
            if(  c == ' ' ){
                mode = 23;
            }
            else if(  c == 0x0d ){
                /* A */
                data_buff[DF_DG_CORRECT] = push_pop;
                mode = 1;
            }
        }
        break;

    case 23:
        if( get_uart0(&c) ){
            if(  c == ' ' ){
                mode = 22;
            }
            else if(  c == 0x0d ){
                /* A */
                data_buff[DF_DG_CORRECT] = push_pop;
                mode = 1;
            }
        }
        break;

    case 31:
        /* AiOZTgPD */
        printf( " AiOZTgPD\n" );
        printf( "   1    : Pl̐ݒ( P=%3d )\n", data_buff[DF_SERVO_P] );
        printf( "   2    : Dl̐ݒ( D=%3d )\n", data_buff[DF_SERVO_D] );
        printf( "   3    : fW^␳̐ݒ( " );
        if( data_buff[DF_DG_CORRECT] ) printf( " )\n" );
        else                           printf( "Ȃ )\n" );
        printf( "   I : Enter\n\n" );
        mode = 32;
        break;

    case 32:
        /* j[̑I */
        if( get_uart0(&c) ){
            if(  c == '1' ){
                mode = 33;
                printf( "          Pl̐ݒ( :  or      : Enter)\n\n" );
                printf( "          P = %3d \r", data_buff[DF_SERVO_P] );
            }
            else if(  c == '2' ){
                mode = 34;
                printf( "          Dl̐ݒ( :  or      : Enter)\n\n" );
                printf( "          D = %3d \r", data_buff[DF_SERVO_D] );
            }
            else if(  c == '3' ){
                mode = 35;
                printf( "          fW^␳̐ݒiI :  or      : Enter)\n\n" );
                if( data_buff[DF_DG_CORRECT] ) printf( "          fW^␳ : \r" );
                else                           printf( "          fW^␳ : Ȃ\r" );
            }
            else if(  c == 0x0d ) mode = 1;
        }
        break;

    case 33:
        /* Pl̒ */
        if( get_uart0(&c) ){
            ParameterChange( &data_buff[DF_SERVO_P] ,BYTE ,0 ,100 ,1 , c );
            printf( "          P = %3d \r", data_buff[DF_SERVO_P] );
            if( c == 0x0d ){
                printf( "\n\n" );
                mode = 31;
            }
        }
        break;

    case 34:
        /* Dl̒ */
        if( get_uart0(&c) ){
            ParameterChange( &data_buff[DF_SERVO_D] ,BYTE ,0 ,100 ,1 , c );
            printf( "          D = %3d \r", data_buff[DF_SERVO_D] );
            if( c == 0x0d ){
                printf( "\n\n" );
                mode = 31;
            }
        }
        break;

    case 35:
        /* fW^␳(EȂ)̐ݒ */
        if( get_uart0(&c) ){
            ParameterChange( &data_buff[DF_DG_CORRECT] ,BYTE ,0 ,1 ,1 , c );
            if( data_buff[DF_DG_CORRECT] ) printf( "          fW^␳ : \r" );
            else                           printf( "          fW^␳ : Ȃ\r" );
            if( c == 0x0d ){
                printf( "\n\n" );
                mode = 31;
            }
        }
        break;

    case 41:
        /* PWM̃~bg */
        printf( " PWMl̃~bg( :  or      : Enter)\n\n" );
        printf( "   PWM = %3d \r", data_buff[DF_LIMIT_PWM] );
        mode = 42;
        break;

    case 42:
        /* PWM̃~bgl̒ */
        if( get_uart0(&c) ){
            ParameterChange( &data_buff[DF_LIMIT_PWM] ,BYTE ,0 ,100 ,1 , c );
            printf( "   PWM = %3d \r", data_buff[DF_LIMIT_PWM] );
            if( c == 0x0d ){
                printf( "\n\n" );
                mode = 1;
            }
        }
        break;

    case 51:
        /* {[l̃~bg */
        printf( " {[l̃~bg( :  or      : Enter)\n\n" );
        printf( "   ݒl = %+04d    VR = %3d \r", getServoAngle(), data_buff[DF_LIMIT_VR] * 2 );
        mode = 52;
        break;

    case 52:
        /* {[l̃~bgl̒ */
        if( get_uart0(&c) ){
            ParameterChange( &data_buff[DF_LIMIT_VR] ,BYTE ,0 ,70 ,1 , c );
            printf( "   ݒl = %+04d    VR = %3d \r", getServoAngle(), data_buff[DF_LIMIT_VR] * 2 );
            if( c == 0x0d ){
                printf( "\n\n" );
                mode = 1;
            }
        }else{
            printf( "   ݒl = %+04d    VR = %3d \r", getServoAngle(), data_buff[DF_LIMIT_VR] * 2 );
        }
        break;

    case 61:
        /* ZT[o[pxop{[l̊mF */
        printf( " ZT[o[pxop{[l̊mF(I : Enter)\n\n" );
        mode = 62;
        break;

    case 62:
        /* ZT[o[pxop{[l@\ */
         printf( "   A/D = %4d \r", ad4 );
        if( get_uart0(&c) ){
            if( c == 0x0d ){
                printf( "\n\n" );
                mode = 1;
            }
        }
        break;

    case 71:
        /* ۑ  */
        printf( "ۑ...\r" );
        writeDataFlashParameter();
        printf( "ݒlۑ܂\n\n" );
        mode = 1;
        break;

    case 81:
        /*   */
        mode = 91;
        break;

    case 91:
        /* ʂ̍ŏ */
        ret = 0; // ĺuv
        printf( "\n\n" );
        printf( "ݒl̏ \n" );
        printf( "  (I :  or    : Enter )\n\n" );
        if( ret ) printf( "  ܂H : ͂   \r" );
        else      printf( "  ܂H :  \r" );
        mode = 92;
        break;

    case 92:
        /* ̑I */
        if( get_uart0(&c) ){
            ParameterChange( &ret ,BYTE ,0 ,1 ,1 , c );
            if( ret ) printf( "  ܂H : ͂   \r" );
            else      printf( "  ܂H :  \r" );
            /* I */
            if( c == 0x0d ){
                printf( "\n\n" );
                if( ret ){
                    mode = 93;
                }
                else{
                    writeDataFlashParameter();
                    mode = 1;
                }
            }
        }
        break;

    case 93:
        /* DF_DATȀ */
        data_buff[DF_CHECK]       = DF_CHECK_VALUE;
        data_buff[DF_INITCHECK]   = DF_INITCHECK_VALUE;
        data_buff[DF_INITCHECK2]  = DF_INITCHECK_VALUE2;
        data_buff[DF_SERVO_P]     = DF_SERVO_P_VALUE;
        data_buff[DF_SERVO_D]     = DF_SERVO_D_VALUE;
        data_buff[DF_DG_CORRECT]  = DF_DG_CORRECT_VALUE;
        data_buff[DF_LIMIT_PWM]   = DF_LIMIT_PWM_VALUE;
        data_buff[DF_LIMIT_VR]    = DF_LIMIT_VR_VALUE;
        writeDataFlashParameter();
        printf( "  ܂\n" );
        mode = 1;
        break;

    case 101:
        /* eZTl̊mF */
        printf( " eZTl̊mF(I : Enter)\n\n" );
        lEncoderTotal = 0;
        cnt1 = 0;
        mode = 102;
        break;
        
    case 102:
        if( cnt1 >= 200 ) {
            cnt1 = 0;
            printf( "Left=%4d , Right=%4d , Digital=%1x , Center=%1d , Bar=%1d\n",
                        ad1, ad0, sensor_inp(), center_inp(), startbar_get() );
            printf( "XeAOADl=%4d , ADl=%4d\n",
                        getServoAngle() , ad4 - saka0_ad );
            printf( "iEncoder(x)=%3d , lEncoderTotal()=%8ld\r",
                        iEncoder , lEncoderTotal );            
            printf("\033[%dA" ,2);  //J[\Ɉړ
        }
        if( get_uart0(&c) ){
            if( c == 0x0d ){
                printf( "\n" );
                printf( "\033[%dB" ,3 ); //J[\Ɉړ
                mode = 1;
            }
        }
        break;

    default:
        mode = 1;
        break;
    }
}

/************************************************************************/
/* p[^̒lp֐@(ő咲͈: -32768 ` +32767 )          */
/*    DataAdr :f[^i[AhX                                 */
/*        Size    :f[^TCY(BYTE or WORD)                           */
/*        Minimum :l̐ݒ͈(ŏl)                                 */
/*        Maximum :l̐ݒ͈(ől)                                 */
/*        Step    :l̑l                                           */
/*                                                                      */
/* QoCgf[^̏ꍇ́AzAĊmۂĂ             */
/*   ܂AʃAhX  ʃAhX̊֌WɂȂ悤ɂĂ   */
/************************************************************************/
void ParameterChange( signed char* DataAdr ,int Size ,
                              int Minimum ,int Maximum ,int Step ,int key)
{
    int             i;
    signed char*    AdrBuff;

    /* f[^i[AhX̎擾 */
    AdrBuff = DataAdr;

    /* l̓ǂݍ */
    switch( Size ){
    case BYTE:
        i  = *DataAdr;
        break;
    case WORD:
        i  = (unsigned char)*DataAdr++ * 0x100;
        i |= (unsigned char)*DataAdr;
        break;
    default:
        break;
    }

    /* l  */
    /* []key */
    if( key == 0x41 ) {
        i += Step;
        if( i > Maximum ) i = Maximum;
    }
    /* []key */
    if( key == 0x42 ) {
        i -= Step;
        if( i < Minimum ) i = Minimum;
    }

    /* li[ */
    switch( Size ){
    case BYTE:
        *AdrBuff   = i & 0xff;
        break;
    case WORD:
        *AdrBuff++ = i >> 8;
        *AdrBuff   = i & 0xff;
        break;
    default:
        break;
    }
}

/************************************************************************/
/* DataFlash̃p[^ǂݍ                                        */
/*          Ȃ                                                    */
/* ߂l       Ȃ                                                    */
/************************************************************************/
void readDataFlashParameter( void )
{
    int             i;
    unsigned int    st = DF_ADDR_END + 1 - DF_PARA_SIZE;
    signed char     c;

    while( 1 ) {
        // ǂݍޔԒnT
        readDataFlash( st, &c, 1 );
        if( c == DF_CHECK_VALUE ) {
            readDataFlash( st, data_buff, DF_PARA_SIZE );
            break;
        }

        st -= DF_PARA_SIZE;

        if( st < DF_ADDR_START ) {
            // Y@߂Ďgp
            for( i=0; i<DF_PARA_SIZE; i++ ) data_buff[ i ] = 0;
            data_buff[DF_CHECK]       = DF_CHECK_VALUE;
            data_buff[DF_INITCHECK]   = DF_INITCHECK_VALUE;
            data_buff[DF_INITCHECK2]  = DF_INITCHECK_VALUE2;
            data_buff[DF_SERVO_P]     = DF_SERVO_P_VALUE;
            data_buff[DF_SERVO_D]     = DF_SERVO_D_VALUE;
            data_buff[DF_DG_CORRECT]  = DF_DG_CORRECT_VALUE;
            data_buff[DF_LIMIT_PWM]   = DF_LIMIT_PWM_VALUE;
            data_buff[DF_LIMIT_VR]    = DF_LIMIT_VR_VALUE;

            blockEraseDataFlash( DF_ADDR_START );
            writeDataFlash( DF_ADDR_START, data_buff, DF_PARA_SIZE );
            break;
        }
    }
}

/************************************************************************/
/* DataFlashփp[^                                        */
/*          Ȃ                                                    */
/* ߂l       Ȃ                                                    */
/************************************************************************/
void writeDataFlashParameter( void )
{
    unsigned int    st = DF_ADDR_START;
    signed char     c;

    while( 1 ) {
        // ޔԒnT
        readDataFlash( st, &c, 1 );
        if( c == -1 ) {
            writeDataFlash( st, data_buff, DF_PARA_SIZE );
            break;
        }

        st += DF_PARA_SIZE;

        if( st > DF_ADDR_END ) {
            // ׂĎgpĂAC[YĐ擪ɏ
            blockEraseDataFlash( DF_ADDR_START );
            writeDataFlash( DF_ADDR_START, data_buff, DF_PARA_SIZE );
            break;
        }
    }
}

/************************************************************************/
/* W[ getCompileMonth                                         */
/* Tv     RpČ擾                              */
/* @       Ȃ                                                    */
/* ߂l                                                             */
/************************************************************************/
int getCompileMonth( const char *p )
{

    static const char monthStr[] =
        { "JanFebMarAprMayJunJulAugSepOctNovDec" }; /* ϊe[u   */

    int i, r;

    for( i=0; i<12; i++ ) {
        r = strncmp( monthStr + i * 3, p, 3 );
        if( r == 0 ) return i + 1;
    }
    return 1;
}

/************************************************************************/
/* W[ getCompileDay                                           */
/* Tv     RpC̓擾                              */
/* @       Ȃ                                                    */
/* ߂l                                                             */
/************************************************************************/
int getCompileDay( const char *p )
{
    int i;

    i = atoi( p + 4 );

    if( i < 1 || i > 31 ) i = 1;

    return i;
}

/************************************************************************/
/* end of file                                                          */
/************************************************************************/

/*
e

Ver.1.00 2013.07.03 vO쐬
Ver.1.03 2015.06.01 parameter_set֐̕sCA
                    ZT[o[pxop{[l̊mFǉ
Ver.1.04 2023.08.14 0Ԃ́ueZTl̊mFvǉ 
*/
