/****************************************************************************/
/* Ώۃ}CR R8C/38A                                                     */
/* ̧ٓe     Advanced}CRJ[vO                          */
/* o[W   Ver.3.00                                                    */
/* Date         2023.08.15                                                  */
/* Copyright    Wp}CRJ[[sψ                        */
/****************************************************************************/

/*======================================*/
/* CN[h                         */
/*======================================*/
#include <stdio.h>
#include "sfr_r838a.h"                  /* R8C/38A SFR̒`t@C    */
#include "types3_beep.h"                /* TypeSuU[䃉Cu    */
#include "microsd_lib.h"                /* microSD䃉Cu        */
#include "lcd_lib.h"                    /* LCD\pǉ                */
#include "switch_lib.h"                 /* XCb`ǉ                 */
#include "data_flash_lib.h"             /* f[^tbVCu   */

/*======================================*/
/* V{`                         */
/*======================================*/
/* 萔ݒ */
#define     ENCODER_1SOU    0     /* GR[_1Ȃ1  2Ȃ0ɂ*/

#define     TRC_MOTOR_CYCLE     20000   /* O,EO[^PWM̎     */
                                        /* 50[ns] * 20000 = 1.00[ms]    */
#define     TRD_MOTOR_CYCLE     20000   /* ,E,ӰPWM̎   */
                                        /* 50[ns] * 20000 = 1.00[ms]    */
#define     FREE                1       /* [^[h@t[         */
#define     BRAKE               0       /* [^[h@u[L       */

/* DataFlash֘A */
#define DF_ADDR_START           0x3000  /* ݊JnAhX         */
#define DF_ADDR_END             0x33ff  /* ݏIAhX         */

#define DF_PARA_SIZE            32      /* DataFlashp[^        */

#define DF_CHECK                0x00    /* DataFlash`FbN            */
#define DF_KYORI                0x01    /*                          */
#define DF_P11_ENC              0x02    /* P11GR[_                */
#define DF_P11_ANG1             0x03    /* P11 pxP                   */

/*======================================*/
/* vg^Cv錾                     */
/*======================================*/
void init( void );
unsigned char sensor_inp( void );
unsigned char center_inp( void );
unsigned char startbar_get( void );
unsigned char dipsw_get( void );
unsigned char dipsw_get2( void );
unsigned char pushsw_get( void );
unsigned char cn6_get( void );
void led_out( unsigned char led );
void motor_r( int accele_l, int accele_r );
void motor2_r( int accele_l, int accele_r );
void motor_f( int accele_l, int accele_r );
void motor2_f( int accele_l, int accele_r );
void motor_mode_r( int mode_l, int mode_r );
void motor_mode_f( int mode_l, int mode_r );
void servoPwmOut( int pwm );
int check_crossline( void );
int check_rightline( void );
int check_leftline( void );
int getServoAngle( void );
int getSakaAngle( void );
int getAnalogSensor( void );
void servoControl( void );
void servoControl2( void );
int diff( int pwm );
void readDataFlashParameter( void );
void writeDataFlashParameter( void );
void lcdProcess( void );
void sakaSyori( void );

/*======================================*/
/* O[oϐ̐錾                 */
/*======================================*/
const char *C_DATE = __DATE__;          /* RpCt           */
const char *C_TIME = __TIME__;          /* RpC           */

int             pattern;                /* }CRJ[p^[     */
int             digital_sensor_hosei_flag; /* ޼پݻ␳ 1: 0:Ȃ*/
unsigned long   cnt1;                   /* ^C}p                     */
unsigned long   check_sen_cnt;          /* ^C}p                     */
unsigned long   check_enc_cnt;          /* ^C}p                     */

/* GR[_֘A */
int             iTimer10;               /* 10msJEgp               */
long            lEncoderTotal;          /* ώZlۑp                 */
int             iEncoder;               /* 10ms̍ŐVl               */
unsigned int    uEncoderBuff;           /* vZp@荞ݓŎgp     */

/*  XeAO[^֘A */
int             iSensorBefore;          /* ÕZTlۑ           */
int             iServoPwm;              /* XeAO[^ovll   */
int             iAngle0;                /* SA/Dlۑ            */

/* XeAO[^֘A2ipxj */
int             iSetAngle;
int             iAngleBefore2;
int             iServoPwm2;

/* ZT֘A */
int             iSensorPattern;         /* ZTԕێp             */

/* TRCWX^̃obt@ */
unsigned int    trcgrb_buff;            /* TRCGRB̃obt@             */
unsigned int    trcgrd_buff;            /* TRCGRD̃obt@             */

/* [^hCuTypeSLEDAfBbvXCb` */
unsigned char   types_led;              /* LEDlݒ                    */
unsigned char   types_dipsw;            /* fBbvXCb`lۑ       */

/* ֍lvZp@e}CRJ[ɍ킹čČvZĉ */
const revolution_difference[] = {       /* pxցAO։]vZ */
    100, 98, 97, 95, 94, 
    92, 91, 89, 88, 87, 
    85, 84, 82, 81, 80, 
    78, 77, 75, 74, 73, 
    71, 70, 69, 68, 66, 
    65, 64, 62, 61, 60, 
    58, 57, 56, 54, 53, 
    52, 50, 49, 47, 46, 
    45, 43, 42, 40, 39, 
    37 };

/* microSD֘Aϐ */
int             msdFlag;                /* 1:f[^L^ 0:L^Ȃ    */
int             msdError;               /* G[ԍL^               */

int             motorLF;                /* O[^PWMlۑ        */
int             motorRF;                /* EO[^PWMlۑ        */
int             motorLR;                /* ヂ[^PWMlۑ        */
int             motorRR;                /* Eヂ[^PWMlۑ        */

/* ⓹op */
unsigned long   cnt_saka;               /* ⓹op^C}             */
int             saka_flag;              /* 1:⓹ 0:⓹ł͂Ȃ      */
int             saka0_ad;               /* n̍⓹{[A/Dl    */
int             saka_pattern;           /* ⓹pp^[           */

/* DataFlash֌W */
signed char     data_buff[ DF_PARA_SIZE ];

/* t֌W */
unsigned long   cnt_lcd;                /* LCDŎgp                */

/************************************************************************/
/* CvO                                                     */
/************************************************************************/
void main( void )
{
    int     i, ret;
    char    fileName[ 8+1+3+1 ];        /* O{'.'{gq{'\0'      */
    unsigned char b;

    /* }CR@\̏ */
    init();                             /*                        */
    setMicroSDLedPort( &p6, &pd6, 0 );  /* microSD j^LEDݒ        */
    asm(" fset I ");                    /* Ŝ̊荞݋           */
    initBeepS();                        /* uU[֘A               */
    initLcd();                          /* LCD                    */
    initSwitch();                       /* XCb`               */

    readDataFlashParameter();           /* DataFlashp[^ǂݍ  */

    /* microSD */
    ret = initMicroSD();
    if( ret != 0x00 ) {
        msdError = 1;
    }

    /* FAT32Ń}Eg */
    if( msdError == 0 ) {
        ret = mountMicroSD_FAT32();
        if( ret != 0x00 ) msdError = 2;
    }

    if( msdError != 0 ) {
        /* microSDɃG[3bԁALED̓_@ς */
        setBeepPatternS( 0xcccc );
        cnt1 = 0;
        while( cnt1 < 3000 ) {
            if( cnt1 % 200 < 100 ) {
                led_out( 0x3 );
            } else {
                led_out( 0x0 );
            }
        }
    }

    cnt1 = 0;                   // 10ms҂
    while( cnt1 <= 10 );

    iAngle0  = ad2;             /* 0ẍʒuL  */
    saka0_ad = ad4;             /* n̍⓹{[A/DlL*/
    
#if 0
    // XeAO[^̊pxp
    iSetAngle = +45;                  /* +ō -ŉEɃnh؂܂    */
    while( 1 ) {
        servoPwmOut( iServoPwm2 );
    }
#endif

    /* }CRJ[̏ԏ */
    motor_mode_f( BRAKE, BRAKE );
    motor_mode_r( BRAKE, BRAKE );
    motor_f( 0, 0 );
    motor_r( 0, 0 );
    servoPwmOut( 0 );

    // dONɃvbVXCb`ĂmF[h
    if( pushsw_get() == 1 ) {
        setBeepPatternS( 0x8880 );
        while( 1 ) {
            if( cnt_lcd >= 250 ) {
                cnt_lcd = 0;
                lcdPosition( 0, 0 );
                         /* 012..456..abcde f  1s16 */
                lcdPrintf( "e=%03d %05ld s=%x%x",
                            iEncoder, lEncoderTotal, center_inp(), sensor_inp() );
                         /* 01.567 abcdef 1s16 */
                lcdPrintf( "%5d%4d%3d",
                            getAnalogSensor(), getServoAngle(), getSakaAngle() );
            }
        }
    }

    setBeepPatternS( 0x8000 );

    while( 1 ) {

    // LCD\Ap[^ݒ菈
    lcdProcess();

    if( pattern >= 11 && pattern <= 100 ) {
        sakaSyori();                    // ⓹

        /* ɂ~ */
        if( lEncoderTotal >= 5459L * data_buff[DF_KYORI] ) {
            pattern = 101;
        }

        /* E֎̒~ifW^ZTj */
        b = sensor_inp();
        if( b == 0x0f || b == 0x0d || b == 0x0b ) {
            if( check_sen_cnt >= 100 ) {
                pattern = 101;
            }
        } else {
            check_sen_cnt = 0;
        }
#if 1   // 쓮[^̃RlN^𔲂āA艟ŊmFƂ͂OɂĖɂ
        /* E֎̒~i[^GR[_j */
        if( iEncoder <= 5 ) {
            if( check_enc_cnt >= 300 ) {
                pattern = 101;
            }
        } else {
            check_enc_cnt = 0;
        }
#endif
    }

    switch( pattern ) {
    case 0:
        /* vbVXCb`҂ */
        servoPwmOut( 0 );
        if( pushsw_get() == 1 ) {
            setBeepPatternS( 0x8000 );
            if( msdError == 0 ) {
                /* microSD̋󂫗̈悩ǂݍ */
                i = readMicroSDNumber();
                if( i == -1 ) {
                    msdError = 3;
                }
            }
            if( msdError == 0 ) {
                /* microSD̋󂫗̈֏  */
                i++;
                if( i >= 10000 ) i = 1;
                ret = writeMicroSDNumber( i );
                if( ret == -1 ) {
                    msdError = 4;
                } else {
                    /* t@Cϊ */
                    sprintf( fileName, "log_%04d.csv", i );
                }
            }
            if( msdError == 0 ) {
                /* t@C̃^CX^vZbg */
                setDateStamp( getCompileYear( C_DATE ),
                    getCompileMonth( C_DATE ),  getCompileDay( C_DATE ) );
                setTimeStamp( getCompileHour( C_TIME ),
                    getCompilerMinute( C_TIME ), getCompilerSecond( C_TIME ) );

                /* ݃t@C쐬 */
                // ݂[ms] : x = 10[ms] : 64oCg
                // 60000msȂAx = 60000 * 64 / 10 = 384000
                // ʂ512̔{ɂȂ悤ɌJグB
                ret = writeFile( fileName, 384000 );
                if( ret != 0x00 ) msdError = 11;

                // microSD
                msdPrintf( "[Your Car Name] Log Data\n" );
                while( checkMsdPrintf() );  // msdPrintf҂
                msdPrintf( "Compile Date:" );
                while( checkMsdPrintf() );  // msdPrintf҂
                msdPrintf( C_DATE );
                while( checkMsdPrintf() );  // msdPrintf҂
                msdPrintf( " Time:" );
                while( checkMsdPrintf() );  // msdPrintf҂
                msdPrintf( C_TIME );
                while( checkMsdPrintf() );  // msdPrintf҂
                msdPrintf( "\n\nLineNo,Pattern,Sensor,Center,"
                           "Analog,Angle,Encoder,O,EO,,E,AD,flag+pattern\n" );
                while( checkMsdPrintf() );  // msdPrintf҂
            }
            writeDataFlashParameter();
            iAngle0  = ad2;             /* 0ẍʒuL  */
            saka0_ad = ad4;             /* n̍⓹{[A/DlL*/
            cnt1 = 0;
            setBeepPatternS( 0x8800 );
            pattern = 1;
            break;
        }
        i =  (cnt1/200) % 2 + 1;
        if( startbar_get() == 1 ) {
            i |= ((cnt1/100 ) % 2 + 1) << 2;
        }
        i |= (p3_2 << 5) | (p3_0 << 4);
        led_out( i );                   /* LED_ŏ                  */
        break;

    case 1:
        /* X^[go[J҂ */
        servoPwmOut( iServoPwm / 5 );
        if( startbar_get() == 0 ) {     // X^[go[̔ȂiJj
            led_out( 0x0 );
            if( msdError == 0 ) msdFlag = 1;    /* f[^L^Jn       */
            cnt1 = 0;
            check_sen_cnt = 0;
            check_enc_cnt = 0;
            lEncoderTotal = 0;
            digital_sensor_hosei_flag = 1;
            pattern = 11;
            break;
        }
        led_out( 1 << (cnt1/50) % 4 );
        break;

    case 11:
        /* ʏg[X */
        servoPwmOut( iServoPwm );
        i = getServoAngle();

        if( saka_flag == 1 ) {          // ⓹tOONȂ猸
            if( iEncoder >= 55 ) {
                motor2_f(   0,   0 );
                motor2_r(   0,   0 );
            } else {
                motor2_f(  95,  95 );
                motor2_r(  95,  95 );
            }
            break;  // case 11͂ŏI
        }

        if( i >= 50 ) {
            if( iEncoder >= 110 ) {
                motor2_f(   0,   0 );
                motor2_r(   0,   0 );
            } else {
                motor2_f(  50,  80 );
                motor2_r(   0,  80 );
            }
        } else if( i <= -50 ) {
            if( iEncoder >= 110 ) {
                motor2_f(   0,   0 );
                motor2_r(   0,   0 );
            } else {
                motor2_f(  80,  50 );
                motor2_r(  80,   0 );
            }
         } else if( i >= data_buff[DF_P11_ANG1] ) {  // l15
            if( iEncoder >= 150 ) {
                motor2_f(   0,   0 );
                motor2_r(   0,   0 );
            } else if( iEncoder >= 109 ) {
                motor2_f( 50, 80 );
                motor2_r(  0, 80 );
            } else {
                motor2_f( diff(80), 80 );
                motor2_r( diff(80), 80 );
            }
       } else if( i <= -data_buff[DF_P11_ANG1] ) {  // l-15
            if( iEncoder >= 150 ) {
                motor2_f(  0,   0 );
                motor2_r(  0,   0 );
            } else if( iEncoder >= 109 ) {
                motor2_f( 80, 50 );
                motor2_r( 80,  0 );
            } else {
                motor2_f( 80, diff(80) );
                motor2_r( 80, diff(80) );
            }
        } else {
            if( iEncoder >= data_buff[DF_P11_ENC]*5 ) {
                motor2_f( 0, 0 );
                motor2_r( 0, 0 );
            } else {
                motor2_f( 100, 100 );
                motor2_r( 100, 100 );
            }
        }
        if( check_crossline() == 1 ) {       /* NXC`FbN         */
            cnt1 = 0;
            digital_sensor_hosei_flag = 0;
            pattern = 21;
        }
        if( check_rightline() == 1 ) {       /* En[tC`FbN       */
            cnt1 = 0;
            digital_sensor_hosei_flag = 0;
            pattern = 51;
        }
        if( check_leftline() == 1 ) {       /* En[tC`FbN       */
            cnt1 = 0;
            digital_sensor_hosei_flag = 0;
            pattern = 61;
        }
        break;

    case 21:
        /* NXCʉߏ */
        servoPwmOut( iServoPwm );
        led_out( 0x3 );
        motor_f( 0, 0 );
        motor_r( 0, 0 );
        if( cnt1 >= 50 ) {
            cnt1 = 0;
            pattern = 22;
        }
        break;

    case 22:
        /* NXC̃g[XApo */
        servoPwmOut( iServoPwm );
        if( iEncoder >= 115 ) {          /* GR[_ɂXs[h */
            motor2_f( -80, -80 );
            motor2_r( -80, -80 );
        } else if( iEncoder >= 110 ) {
            motor2_f( 0, 0 );
            motor2_r( 0, 0 );
        } else {
            motor2_f( 70, 70 );
            motor2_r( 70, 70 );
        }

        if( (sensor_inp() & 0x01) == 0x01 ) { /* ENNH             */
            led_out( 0x1 );
            cnt1 = 0;
            pattern = 31;
            break;
        }
        if( (sensor_inp() & 0x08) == 0x08 ) {  /* NNH            */
            led_out( 0x2 );
            cnt1 = 0;
            pattern = 41;
            break;
        }
        break;

    case 31:
        /* ENN */
        servoPwmOut( 90 );              /* servoPwmOut́A+ŉE -ōɉ񂵂܂ */          
        motor_f( 60,  0 );
        motor_r( 49, 22 );
        if( sensor_inp() == 0x04 ) {    /* ȂI`FbN           */
            cnt1 = 0;
            iSensorPattern = 0;
            digital_sensor_hosei_flag = 1;
            pattern = 32;
        }
        break;

    case 32:
        /* Ԃo܂ő҂ */
        servoPwmOut( iServoPwm );
        motor2_r( 80, 80 );
        motor2_f( 80, 80 );
        if( cnt1 >= 100 ) {
            led_out( 0x0 );
            pattern = 11;
        }
        break;

    case 41:
        /* NN */
        servoPwmOut( -90 );             /* servoPwmOut́A+ŉE -ōɉ񂵂܂ */ 
        motor_f(  0, 60 );
        motor_r( 22, 49 );
        if( sensor_inp() == 0x02 ) {    /* ȂI`FbN           */
            cnt1 = 0;
            iSensorPattern = 0;
            digital_sensor_hosei_flag = 1;
            pattern = 42;
        }
        break;

    case 42:
        /* Ԃo܂ő҂ */
        servoPwmOut( iServoPwm );
        motor2_f( 80, 80 );
        motor2_r( 80, 80 );
        if( cnt1 >= 100 ) {
            led_out( 0x0 );
            pattern = 11;
        }
        break;

    case 51:
        /* E[`FW@En[tCo */
        servoPwmOut( iServoPwm );
        motor2_f( 50, 50 );
        motor2_r( 50, 50 );
        led_out( 0xc0 );
        pattern = 52;
        cnt1 = 0;
        break;

    case 52:
        /* E[`FW@En[tCʂ߂܂ő҂ */
        servoPwmOut( iServoPwm );
        if( cnt1 > 50 ) {
            pattern = 53;
        }
        if( check_crossline() == 1 ) {       /* En[tC`FbN       */
            cnt1 = 0;
            pattern = 21;
        }
        break;

    case 53:
        /* E[`FW@SȂȂ܂Ői */
        servoPwmOut( iServoPwm );
        if( iEncoder >= 110 ) {          /* GR[_ɂXs[h */
            motor2_f( 0, 0 );
            motor2_r( 0, 0 );
        } else {
            motor2_f( 70, 70 );
            motor2_r( 70, 70 );
        }
        if( center_inp() == 0 ) {
            pattern = 54;
            break;
        }
        break;

    case 54:
        /* E[`FW@VS܂ŉEɋȂ */
        iSetAngle = -45;                  /* +ō -ŉEɃnh؂܂*/
        servoPwmOut( iServoPwm2 );
        motor2_f( 50, 0 );
        motor2_r( 50, 20 );
        if( (sensor_inp()&0x04) == 0x04 ) {
            pattern = 55;
            led_out( 0x00 );
            iSensorPattern = 0;
            digital_sensor_hosei_flag = 1;
            cnt1 = 0;
            break;
        }
        break;

    case 55:
        /* E[`FW@VSg[X */
        servoPwmOut( iServoPwm );
        motor2_f(  0, 50 );
        motor2_r( 20, 50 );
        if( cnt1 > 100 ) {
            pattern = 11;
            cnt1 = 0;
        }
        break;

    case 61:
        /* [`FW@n[tCo */
        servoPwmOut( iServoPwm );
        motor2_f( 50, 50 );
        motor2_r( 50, 50 );
        led_out( 0x30 );
        pattern = 62;
        cnt1 = 0;
        break;

    case 62:
        /* [`FW@n[tCʂ߂܂ő҂ */
        servoPwmOut( iServoPwm );
        if( cnt1 > 50 ) {
            pattern = 63;
        }
        if( check_crossline() == 1 ) {       /* n[tC`FbN       */
            cnt1 = 0;
            pattern = 21;
        }
        break;

    case 63:
        /* [`FW@SȂȂ܂Ői */
        servoPwmOut( iServoPwm );
        if( iEncoder >= 110 ) {          /* GR[_ɂXs[h */
            motor2_f( 0, 0 );
            motor2_r( 0, 0 );
        } else {
            motor2_f( 70, 70 );
            motor2_r( 70, 70 );
        }
        if( center_inp() == 0 ) {
            pattern = 64;
            break;
        }
        break;

    case 64:
        /* [`FW@VS܂ŉEɋȂ */
        iSetAngle = 40;                  /* +ō -ŉEɃnh؂܂*/
        servoPwmOut( iServoPwm2 );
        motor2_f( 0, 50 );
        motor2_r( 0, 50 );
        if( (sensor_inp()&0x04) == 0x04 ) {
            pattern = 65;
            led_out( 0x00 );
            iSensorPattern = 0;
            digital_sensor_hosei_flag = 1;
            cnt1 = 0;
            break;
        }
        break;

    case 65:
        /* [`FW@VSg[X */
        servoPwmOut( iServoPwm );
        motor2_f( 50, 0 );
        motor2_r( 50, 20 );
        if( cnt1 > 100 ) {
            pattern = 11;
            cnt1 = 0;
        }
        break;

    case 101:
        /* ~ */
        servoPwmOut( iServoPwm );
        motor2_f( 0, 0 );
        motor2_r( 0, 0 );
        digital_sensor_hosei_flag = 0;
        pattern = 102;
        cnt1 = 0;
        break;

    case 102:
        servoPwmOut( iServoPwm );
        if( iEncoder <= 5 ) {
            servoPwmOut( 0 );
            led_out( 0x55 );
            pattern = 103;
            setBeepPatternS( 0xcc00 );
            cnt1 = 0;
            break;
        }
        break;

    case 103:
        if( cnt1 > 500 ) {
            msdFlag = 0;
            pattern = 104;
            cnt1 = 0;
            break;
        }
        break;

    case 104:
        /* Ō̃f[^܂܂ő҂ */
        if( microSDProcessEnd() == 0 ) {
            pattern = 105;
        }
        break;

    case 105:
        /* Ȃ */
        break;

    default:
        break;
    }
    }
}

/************************************************************************/
/* R8C/38A XyVt@NVWX^(SFR)̏                */
/************************************************************************/
void init( void )
{
    int     i;

    /* NbNXINNbN(20MHz)ɕύX */
    prc0  = 1;                          /* veNg               */
    cm13  = 1;                          /* P4_6,P4_7XIN-XOUT[qɂ*/
    cm05  = 0;                          /* XINNbNU              */
    for(i=0; i<50; i++ );               /* 肷܂ŏ҂(10ms) */
    ocd2  = 0;                          /* VXeNbNXINɂ  */
    prc0  = 0;                          /* veNgON                 */

    /* |[g̓o͐ݒ */

    /*  PWM(\)       OM_PMW       EOM_PWM       uU[
        ZT[      ZT      ZTE      ZTE[  */
    p0   = 0x00;
    prc2 = 1;                           /* PD0̃veNg          */
    pd0  = 0xf0;

    /*  ZTS      ް         RxD0            TxD0
        DIPSW3          DIPSW2          DIPSW1          DIPSW0          */
    pur0 |= 0x04;                       /* P1_3`P1_0̃vAbvON     */
    p1  = 0x00;
    pd1 = 0x10;

    /*  EOM_      XeAM_    XeAM_PWM     EM_PWM
        EM_      M_PWM       M_      OM_      */
    p2  = 0x00;
    pd2 = 0xff;

    /*  tEmicroSD10sRlN^

        none            none            none            none
        none            GR[_B   none            GR[_A   */
    p3  = 0x00;
    pd3 = 0xfa;

    /*  XOUT            XIN             {[hLED   none
        none            VREF            none            none            */
    p4  = 0x20;                         /* P4_5LED:͓_         */
    pd4 = 0xb8;

    /*  tEmicroSD                                               */
    p5  = 0x00;
    pd5 = 0x7f;

    /*  tEmicroSD                                               */
    p6  = 0x00;
    pd6 = 0xff;

    /*  CN6.2       CN6.3       CN6.4       CN6.5
        ݼҰ@   pxݼҰ   ZT_۸  ZT_E۸  */
    p7  = 0x00;
    pd7 = 0x00;

    /*  DIPSWorLED      DIPSWorLED      DIPSWorLED      DIPSWorLED
        DIPSWorLED      DIPSWorLED      DIPSWorLED      DIPSWorLED      */
    pur2 |= 0x03;                       /* P8_7`P8_0̃vAbvON     */
    p8  = 0x00;
    pd8 = 0x00;

    /*  -               -               ߯       P8(LEDorSW)
        EOM_Free      OM_Free      EM_Free      M_Free      */
    p9  = 0x00;
    pd9 = 0x1f;
    pu23 = 1;   // P9_4,P9_5vAbv

    /* ^C}RB̐ݒ */
    /* 荞ݎ = 1 / 20[MHz]   * (TRBPRE+1) * (TRBPR+1)
                    = 1 / (20*10^6) * 200        * 100
                    = 0.001[s] = 1[ms]                                  */
    trbmr  = 0x00;                      /* 샂[hAݒ       */
    trbpre = 200-1;                     /* vXP[WX^         */
    trbpr  = 100-1;                     /* vC}WX^           */
    trbic  = 0x06;                      /* 荞ݗD惌xݒ       */
    trbcr  = 0x01;                      /* JEgJn                 */

    /* A/DRo[^̐ݒ */
    admod   = 0x33;                     /* JԂ|[hɐݒ     */
    adinsel = 0xb0;                     /* ͒[qP78[qI      */
    adcon1  = 0x30;                     /* A/D\                  */
    asm(" nop ");                       /* AD1TCNEGCg*/
    adcon0  = 0x01;                     /* A/DϊX^[g              */

    /* ^C}RC PWM[hݒ(O[^AEO[^) */
    trcpsr0 = 0x40;                     /* TRCIOA,B[q̐ݒ           */
    trcpsr1 = 0x33;                     /* TRCIOC,D[q̐ݒ           */
    trcmr   = 0x0f;                     /* PWM[hIrbgݒ      */
    trccr1  = 0x8e;                     /* :f1,o͂̐ݒ    */
    trccr2  = 0x00;                     /* o̓x̐ݒ             */
    trcgra  = TRC_MOTOR_CYCLE - 1;      /* ݒ                     */
    trcgrb  = trcgrb_buff = trcgra;     /* P0_5[qON(O[^)   */
    trcgrc  = trcgra;                   /* P0_7[qON(\)         */
    trcgrd  = trcgrd_buff = trcgra;     /* P0_6[qON(EO[^)   */
    trcic   = 0x07;                     /* 荞ݗD惌xݒ       */
    trcier  = 0x01;                     /* IMIA                   */
    trcoer  = 0x01;                     /* o͒[q̑I               */
    trcmr  |= 0x80;                     /* TRCJEgJn              */

    /* ^C}RD ZbgPWM[hݒ(ӰAEӰAӰ) */
    trdpsr0 = 0x08;                     /* TRDIOB0,C0,D0[qݒ        */
    trdpsr1 = 0x05;                     /* TRDIOA1,B1,C1,D1[qݒ     */
    trdmr   = 0xf0;                     /* obt@WX^ݒ         */
    trdfcr  = 0x01;                     /* ZbgPWM[hɐݒ  */
    trdcr0  = 0x20;                     /* \[XJEg̑I:f1      */
    trdgra0 = trdgrc0 = TRD_MOTOR_CYCLE - 1;    /* ݒ             */
    trdgrb0 = trdgrd0 = 0;              /* P2_2[qON(ヂ[^)   */
    trdgra1 = trdgrc1 = 0;              /* P2_4[qON(Eヂ[^)   */
    trdgrb1 = trdgrd1 = 0;              /* P2_5[qON(ñݸӰ)   */
    trdoer1 = 0xcd;                     /* o͒[q̑I               */
    trdstr  = 0x0d;                     /* TRD0JEgJn             */

    // ^C}RG [^GR[_̃pXJEgp
#if ENCODER_1SOU // 1Ȃ1 2Ȃ0ɂ
    tstart_trgmr = 0;                   /* TRG̃JEg~            */
    timsr = 0x40;                       /* TRGCLKA[q P3_0Ɋ蓖Ă */
    trgcr = 0x15;                       /* TRGCLKA[q̗GbWŃJEg*/
    trgmr = 0x80;                       /* TRG̃JEgJn            */
#else
    tstart_trgmr = 0;                   /* TRG̃JEg~            */
    timsr = 0xc0;                       /* TRGCLKA[qP3_0,           */
                                        /*   TRGCLKB[qP3_2Ɋ蓖*/
    trgcntc = 0xff;                     /* ʑvӰނ̶ĕ@w   */
    trgmr = 0x82;                       /* TRG̃JEgJn            */
#endif
}

/************************************************************************/
/* ^C}RB 1msƂ̊荞ݏ                                       */
/************************************************************************/
#pragma interrupt /B intTRB(vect=24)
void intTRB( void )
{
    static int  line_no;                /* sԍ                       */
    unsigned int i;

    asm(" fset I ");                    /* ^C}RBȏ̊荞݋   */

    cnt1++;
    check_sen_cnt++;
    check_enc_cnt++;
    cnt_saka++;                         /*sakaSyori֐̎Ԍvp   */
    cnt_lcd++;

    /* gXCb`p֐(1msƂɎs)    */
    switchProcess();

    /* LCD\p֐(1msƂɎs)     */
    lcdShowProcess();

    /* XeAO[^ */
    servoControl();
    servoControl2();

    /* uU[ */
    beepProcessS();

    /* microSDԌݏ(1msƂɎs)   */
    microSDProcess();

    /* 101s鏈 */
    iTimer10++;
    switch( iTimer10 ) {
    case 1:
        /* GR[_ */
        i = trg;
        iEncoder       = i - uEncoderBuff;
        lEncoderTotal += iEncoder;
        uEncoderBuff = i;
        break;

    case 2:
        /* XCb`ǂݍݏ */
        p9_4 = 0;                       /* LEDoOFF                   */
        pd8  = 0x00;
        break;

    case 3:
        /* XCb`ǂݍ݁ALEDo */
        types_dipsw = ~p8;              /* ײފTypeSSWǂݍ    */
        p8  = types_led;                /* ײފTypeSLED֏o */
        pd8 = 0xff;
        p9_4 = 1;                       /* LEDoON                    */
        break;

    case 4:
        break;

    case 5:
        break;

    case 6:
        break;

    case 7:
        break;

    case 8:
        break;

    case 9:
        /* microSDL^ */
        if( msdFlag == 1 ) {
            msdPrintf( "%3d,%3d,'%4b,%c,%5d,%4d,%3d,%4d,%4d,%4d,%4d,%3d,'%1d%2d\r\n",
                line_no,            // sԍ
                pattern,            // p^[ԍ
                sensor_inp(),       // fW^ZTi4bitj
                center_inp() + '0', // fW^ZTiSj
                getAnalogSensor(),  // AiOZT
                getServoAngle(),    // {[iXeAOpxj
                iEncoder,           // [^GR[_
                motorLF,            // O[^
                motorRF,            // EO[^
                motorLR,            // ヂ[^
                motorRR,            // Eヂ[^
                getSakaAngle(),     // A/Dl
                saka_flag,          // tO
                saka_pattern        // ⓹pp^[ԍ
            );

            if( ++line_no >= 1000 ) line_no = 0;
        }
        break;

    case 10:
        /* iTimer10ϐ̏ */
        iTimer10 = 0;
        break;
    }
}

/*
msdPrintfgp̒ӓ_

EmicroSDɓWJ镶́A1s(CR(\r),LF(\n)܂߂)64܂ŁB
ÉA20x܂ŁB
EmsdPrintf֐́A10msƂɎs(10msԂ64܂)B
E10msȉŃOL^ꍇ́AϐɒlۑĂA
  msdPrintf֐sƂɁA܂Ƃ߂ďo͂B
  jmsdPrintf( "%3d%3d\r\n%3d%3d\r\n", s1, m1, s2, m2 );
      s1m1:5msO̒lAs2m2:̒l
EmsdPrintf֐̖߂l0ȂZbgA0ȊOȂÕf[^
  ݒŁÃf[^͏݂łB
  ) ret = msdPrintf( "%5d\r\n", i );
      while( checkMsdPrintf() );  // msdPrintf҂
*/

/************************************************************************/
/* ^C}RC 荞ݏ                                                */
/************************************************************************/
#pragma interrupt intTRC(vect=7)
void intTRC( void )
{
    trcsr &= 0xfe;

    /* ^C}RC@f[eB̐ݒ */
    trcgrb = trcgrb_buff;
    trcgrd = trcgrd_buff;
}

/************************************************************************/
/* AiOZTTypeS̃fW^ZTlǂݍ                    */
/* @ Ȃ                                                          */
/* ߂l [AAEAE[̃fW^ZT 0: 1:              */
/************************************************************************/
unsigned char sensor_inp( void )
{
    unsigned char sensor;

    sensor = ~p0 & 0x0f;

    return sensor;
}

/************************************************************************/
/* AiOZTTypeS̒SfW^ZTǂݍ                  */
/* @ Ȃ                                                          */
/* ߂l SfW^ZT 0: 1:                                  */
/************************************************************************/
unsigned char center_inp( void )
{
    unsigned char sensor;

    sensor = ~p1_7 & 0x01;

    return sensor;
}

/************************************************************************/
/* AiOZTTypeS̃X^[go[oZTǂݍ              */
/* @ Ȃ                                                          */
/* ߂l 0:X^[go[Ȃ 1:X^[go[                         */
/************************************************************************/
unsigned char startbar_get( void )
{
    unsigned char sensor;

    sensor = ~p1_6 & 0x01;

    return sensor;
}

/************************************************************************/
/* }CR{[h̃fBbvXCb`lǂݍ                         */
/* @ Ȃ                                                          */
/* ߂l XCb`l 0`15                                              */
/************************************************************************/
unsigned char dipsw_get( void )
{
    unsigned char sw;

    sw = p1 & 0x0f;                     /* P1_3`P1_0ǂݍ           */

    return sw;
}

/************************************************************************/
/* [^hCuTypeS̃fBbvXCb`lǂݍ                */
/* @ Ȃ                                                          */
/* ߂l XCb`l 0`255                                             */
/************************************************************************/
unsigned char dipsw_get2( void )
{
    /* ۂ̓͂̓^C}RB荞ݏŎ{ */
    return types_dipsw;
}

/************************************************************************/
/* [^hCuTypeS̃vbVXCb`lǂݍ                */
/* @ Ȃ                                                          */
/* ߂l XCb`l 0:OFF 1:ON                                         */
/************************************************************************/
unsigned char pushsw_get( void )
{
    unsigned char sw;

    sw = ~p9_5 & 0x01;

    return sw;
}

/************************************************************************/
/* [^hCuTypeSCN6̏ԓǂݍ                           */
/* @ Ȃ                                                          */
/* ߂l 0`15                                                         */
/************************************************************************/
unsigned char cn6_get( void )
{
    unsigned char data;

    data = p7 >> 4;

    return data;
}

/************************************************************************/
/* [^hCuTypeSLED                                     */
/* @ 8LED 0:OFF 1:ON                                       */
/* ߂l Ȃ                                                          */
/************************************************************************/
void led_out( unsigned char led )
{
    /* ۂ̏o͂̓^C}RB荞ݏŎ{ */
    types_led = led;
}

/************************************************************************/
/* ւ̑x(fBbvXCb`Ō)                           */
/* @ [^:-100`100 , E[^:-100`100                       */
/*        0Œ~A100Ő]100%A-100ŋt]100%                        */
/* ߂l Ȃ                                                          */
/************************************************************************/
void motor_r( int accele_l, int accele_r )
{
    int sw_data;

    sw_data  = dipsw_get() + 5;         /* fBbvXCb`ǂݍ     */
    accele_l = accele_l * sw_data / 20;
    accele_r = accele_r * sw_data / 20;

    motorLR = accele_l;
    motorRR = accele_r;

    /* ヂ[^ */
    if( accele_l >= 0 ) {
        p2_1 = 0;
        trdgrd0 = (long)( TRD_MOTOR_CYCLE - 2 ) * accele_l / 100;
    } else {
        p2_1 = 1;
        trdgrd0 = (long)( TRD_MOTOR_CYCLE - 2 ) * ( -accele_l ) / 100;
    }

    /* Eヂ[^ */
    if( accele_r >= 0 ) {
        p2_3 = 0;
        trdgrc1 = (long)( TRD_MOTOR_CYCLE - 2 ) * accele_r / 100;
    } else {
        p2_3 = 1;
        trdgrc1 = (long)( TRD_MOTOR_CYCLE - 2 ) * ( -accele_r ) / 100;
    }
}

/************************************************************************/
/* ւ̑x2 fBbvXCb`ɂ͊֌WȂmotor֐              */
/* @ [^:-100`100 , E[^:-100`100                       */
/*        0Œ~A100Ő]100%A-100ŋt]100%                        */
/* ߂l Ȃ                                                          */
/************************************************************************/
void motor2_r( int accele_l, int accele_r )
{
    motorLR = accele_l;
    motorRR = accele_r;

    /* ヂ[^ */
    if( accele_l >= 0 ) {
        p2_1 = 0;
        trdgrd0 = (long)( TRD_MOTOR_CYCLE - 2 ) * accele_l / 100;
    } else {
        p2_1 = 1;
        trdgrd0 = (long)( TRD_MOTOR_CYCLE - 2 ) * ( -accele_l ) / 100;
    }

    /* Eヂ[^ */
    if( accele_r >= 0 ) {
        p2_3 = 0;
        trdgrc1 = (long)( TRD_MOTOR_CYCLE - 2 ) * accele_r / 100;
    } else {
        p2_3 = 1;
        trdgrc1 = (long)( TRD_MOTOR_CYCLE - 2 ) * ( -accele_r ) / 100;
    }
}

/************************************************************************/
/* Oւ̑x(fBbvXCb`Ō)                           */
/* @ [^:-100`100 , E[^:-100`100                       */
/*        0Œ~A100Ő]100%A-100ŋt]100%                        */
/* ߂l Ȃ                                                          */
/************************************************************************/
void motor_f( int accele_l, int accele_r )
{
    int sw_data;

    sw_data  = dipsw_get() + 5;         /* fBbvXCb`ǂݍ     */
    accele_l = accele_l * sw_data / 20;
    accele_r = accele_r * sw_data / 20;

    motorLF = accele_l;
    motorRF = accele_r;

    /* O[^ */
    if( accele_l >= 0 ) {
        p2_0 = 0;
    } else {
        p2_0 = 1;
        accele_l = -accele_l;
    }
    if( accele_l <= 5 ) {
        trcgrb = trcgrb_buff = trcgra;
    } else {
        trcgrb_buff = (unsigned long)(TRC_MOTOR_CYCLE-2) * accele_l / 100;
    }

    /* EO[^ */
    if( accele_r >= 0 ) {
        p2_7 = 0;
    } else {
        p2_7 = 1;
        accele_r = -accele_r;
    }
    if( accele_r <= 5 ) {
        trcgrd = trcgrd_buff = trcgra;
    } else {
        trcgrd_buff = (unsigned long)(TRC_MOTOR_CYCLE-2) * accele_r / 100;
    }
}

/************************************************************************/
/* Oւ̑x2 fBbvXCb`ɂ͊֌WȂmotor֐              */
/* @ [^:-100`100 , E[^:-100`100                       */
/*        0Œ~A100Ő]100%A-100ŋt]100%                        */
/* ߂l Ȃ                                                          */
/************************************************************************/
void motor2_f( int accele_l, int accele_r )
{
    motorLF = accele_l;
    motorRF = accele_r;

    /* O[^ */
    if( accele_l >= 0 ) {
        p2_0 = 0;
    } else {
        p2_0 = 1;
        accele_l = -accele_l;
    }
    if( accele_l <= 5 ) {
        trcgrb = trcgrb_buff = trcgra;
    } else {
        trcgrb_buff = (unsigned long)(TRC_MOTOR_CYCLE-2) * accele_l / 100;
    }

    /* EO[^ */
    if( accele_r >= 0 ) {
        p2_7 = 0;
    } else {
        p2_7 = 1;
        accele_r = -accele_r;
    }
    if( accele_r <= 5 ) {
        trcgrd = trcgrd_buff = trcgra;
    } else {
        trcgrd_buff = (unsigned long)(TRC_MOTOR_CYCLE-2) * accele_r / 100;
    }
}

/************************************************************************/
/* ヂ[^~iu[LAt[j                                 */
/* @ [^:FREE or BRAKE , E[^:FREE or BRAKE               */
/* ߂l Ȃ                                                          */
/************************************************************************/
void motor_mode_r( int mode_l, int mode_r )
{
    if( mode_l ) {
        p9_0 = 1;
    } else {
        p9_0 = 0;
    }
    if( mode_r ) {
        p9_1 = 1;
    } else {
        p9_1 = 0;
    }
}

/************************************************************************/
/* O[^~iu[LAt[j                                 */
/* @ [^:FREE or BRAKE , E[^:FREE or BRAKE               */
/* ߂l Ȃ                                                          */
/************************************************************************/
void motor_mode_f( int mode_l, int mode_r )
{
    if( mode_l ) {
        p9_2 = 1;
    } else {
        p9_2 = 0;
    }
    if( mode_r ) {
        p9_3 = 1;
    } else {
        p9_3 = 0;
    }
}

/************************************************************************/
/* XeAO[^                                                 */
/* @ XeAO[^PWMF-100`100                              */
/*        0Œ~A100Ő]100%A-100ŋt]100%                        */
/* ߂l Ȃ                                                          */
/************************************************************************/
void servoPwmOut( int pwm )
{
    /* {[lɂ荶~bg */
    if( getServoAngle() >= 120 && pattern >= 11 ) {
        if( pwm < -10 ) pwm = 0;
    }
    /* {[lɂE~bg */
    if( getServoAngle() <= -120 && pattern >= 11 ) {
        if( pwm >  10 ) pwm = 0;
    }

    if( pwm >= 0 ) {
        p2_6 = 0;
        trdgrd1 = (long)( TRD_MOTOR_CYCLE - 2 ) * pwm / 100;
    } else {
        p2_6 = 1;
        trdgrd1 = (long)( TRD_MOTOR_CYCLE- 2 ) * ( -pwm ) / 100;
    }
}

/************************************************************************/
/* NXCo                                                 */
/* @ Ȃ                                                          */
/* ߂l 0:NXCȂ 1:                                     */
/************************************************************************/
int check_crossline( void )
{
    unsigned char b;
    int ret = 0;

    b = sensor_inp();
    if( b==0x0f || b==0x0e || b==0x0d || b==0x0b || b==0x07 ) {
        ret = 1;
    }
    return ret;
}

/************************************************************************/
/* En[tCo                                               */
/* @ Ȃ                                                          */
/* ߂l 0:En[tCȂ 1:                                   */
/************************************************************************/
int check_rightline( void )
{
    unsigned char b;
    int ret = 0;

    if( ( center_inp() == 1 ) && ( sensor_inp() == 0x03 ) ) {
        ret = 1;
    }
    return ret;
}

/************************************************************************/
/* n[tCo                                               */
/* @ Ȃ                                                          */
/* ߂l 0:n[tCȂ 1:                                   */
/************************************************************************/
int check_leftline( void )
{
    unsigned char b;
    int ret = 0;

    if( ( center_inp() == 1 ) && ( sensor_inp() == 0x0c ) ) {
        ret = 1;
    }
    return ret;
}

/************************************************************************/
/* XeAOpx擾                                                 */
/* @ Ȃ                                                          */
/* ߂l nhpxA/Dl                                           */
/************************************************************************/
int getServoAngle( void )
{
    return( ad2 - iAngle0 );
}

/************************************************************************/
/* px擾                                                           */
/* @ Ȃ                                                          */
/* ߂l pxA/Dl                                                 */
/************************************************************************/
int getSakaAngle( void )
{
    return ( ad4 - saka0_ad );              // A/Dl
}

/************************************************************************/
/* AiOZTl擾                                                 */
/* @ Ȃ                                                          */
/* ߂l ZTl                                                      */
/************************************************************************/
int getAnalogSensor( void )
{
    int ret;

    ret = ad1 - ad0;                    /* AiOZT擾       */

    if( digital_sensor_hosei_flag == 1 ) {
        /* fW^ZT␳tOPȂ␳ */
        switch( iSensorPattern ) {
        case 0:
            if( sensor_inp() == 0x04 ) {
                ret = -700;
                break;
            }
            if( sensor_inp() == 0x02 ) {
                ret = 700;
                break;
            }
            if( sensor_inp() == 0x0c ) {
                ret = -800;
                iSensorPattern = 1;
                break;
            }
            if( sensor_inp() == 0x03 ) {
                ret = 800;
                iSensorPattern = 2;
                break;
            }
            break;

        case 1:
            /* ZTE */
            ret = -800;
            if( sensor_inp() == 0x04 ) {
                iSensorPattern = 0;
            }
            break;

        case 2:
            /* ZT */
            ret = 800;
            if( sensor_inp() == 0x02 ) {
                iSensorPattern = 0;
            }
            break;
        }
    } else {
        /* fW^ZT␳tOOȂ␳Ȃ */
        iSensorPattern = 0;
    }

    return ret;
}

/************************************************************************/
/* XeAO[^ PD                                            */
/* @ Ȃ                                                          */
/* ߂l O[oϐ iServoPwm ɑ                               */
/************************************************************************/
void servoControl( void )
{
    int i, iRet, iP, iD;
    int kp, kd;

    i = getAnalogSensor();              /* ZTl擾                 */
    kp = dipsw_get2() & 0x0f;           /* łP,Dl͌Œl  */
    kd = (dipsw_get2() >> 4) * 5;       /* Ă                 */

    /* XeAO[^pPWMlvZ */
    iP = kp * i;                        /*                          */
    iD = kd * (iSensorBefore - i );     /* (ڈP5`10{)       */
    iRet = iP - iD;
    iRet /= 64;

    /* PWM̏A̐ݒ */
    if( iRet >  90 ) {
        iRet =  90;
    }
    if( iRet < -90 ) {
        iRet = -90;
    }
    iServoPwm = iRet;

    iSensorBefore = i;                  /* ͂̒l1msO̒lƂȂ*/
}

/************************************************************************/
/* XeAO[^ pxPD                                      */
/* @ Ȃ                                                          */
/* ߂l O[oϐ iServoPwm2 ɑ                              */
/************************************************************************/
void servoControl2( void )
{
    int i, j, iRet, iP, iD;
    int kp, kd;

    i = iSetAngle;
    j = getServoAngle();

    /* XeAO[^pPWMlvZ */
    iP = 20 * ( j - i );                /*                          */
    iD = 100 * ( iAngleBefore2 - j );   /* (ڈP5`10{)       */
    iRet = iP - iD;
    iRet /= 2;

    /* PWM̏A̐ݒ */
    if( iRet >  90 ) {
        iRet =  90;
    }
    if( iRet < -90 ) {
        iRet = -90;
    }
    iServoPwm2 = iRet;

    iAngleBefore2 = j;                  /* ͂̒l1msO̒lƂȂ*/
}

/************************************************************************/
/* OւPWMAւPWMo@nhpx݂͌̒lgp     */
/* @ OPWM                                                       */
/* ߂l PWM                                                       */
/************************************************************************/
int diff( int pwm )
{
    int i, ret;

    i  = getServoAngle() / 3;           /* 1x̑Ŋ        */
    if( i <  0 ) i = -i;
    if( i > 45 ) i = 45;
    ret = revolution_difference[i] * pwm / 100;

    return ret;
}

/************************************************************************/
/* DataFlash̃p[^ǂݍ                                        */
/*          Ȃ                                                    */
/* ߂l       Ȃ                                                    */
/************************************************************************/
void readDataFlashParameter( void )
{
    const int       DF_CHECK_value = 0x55;
    int             i;
    unsigned int    st = DF_ADDR_END + 1 - DF_PARA_SIZE;
    signed char     c;

    while( 1 ) {
        // ǂݍޔԒnT
        readDataFlash( st, &c, 1 );
        if( c == DF_CHECK_value ) {
            readDataFlash( st, data_buff, DF_PARA_SIZE );
            break;
        }

        st -= DF_PARA_SIZE;

        if( st < DF_ADDR_START ) {
            // Y@߂Ďgp
            for( i=0; i<DF_PARA_SIZE; i++ ) data_buff[ i ] = 0;
            data_buff[DF_CHECK]     = DF_CHECK_value;
            data_buff[DF_KYORI]     = 60;
            data_buff[DF_P11_ENC]   = 27;  // 5{Ďgp [^GR[_TypeS1m/s=55
            data_buff[DF_P11_ANG1]  = 15;

            blockEraseDataFlash( DF_ADDR_START );
            writeDataFlash( DF_ADDR_START, data_buff, DF_PARA_SIZE );
            break;
        }
    }
}

/************************************************************************/
/* DataFlashփp[^                                        */
/*          Ȃ                                                    */
/* ߂l       Ȃ                                                    */
/************************************************************************/
void writeDataFlashParameter( void )
{
    unsigned int    st = DF_ADDR_START;
    signed char     c;

    while( 1 ) {
        // ޔԒnT
        readDataFlash( st, &c, 1 );
        if( c == -1 ) {
            writeDataFlash( st, data_buff, DF_PARA_SIZE );
            break;
        }

        st += DF_PARA_SIZE;

        if( st > DF_ADDR_END ) {
            // ׂĎgpAC[YĐ擪ɏ
            blockEraseDataFlash( DF_ADDR_START );
            writeDataFlash( DF_ADDR_START, data_buff, DF_PARA_SIZE );
            break;
        }
    }
}


/************************************************************************/
/* LCDƃXCb`gp[^Zbg                            */
/*          Ȃ                                                    */
/* ߂l       Ȃ                                                    */
/************************************************************************/
void lcdProcess( void )
{
    static int lcd_pattern = 0;
    int i;

    if( pattern != 0 ) {
        if( cnt_lcd >= 250 ) {
            cnt_lcd = 0;
            lcdPosition( 0, 0 );
                     /* 0123456789abcde f 1s16 */
            lcdPrintf( "p=%3d e=%3d s=%x%x", 
                        pattern, iEncoder, center_inp(), sensor_inp() );
                     /* 01.567 abcdef 1s16 */
            lcdPrintf( "%5d%4d%3d",
                        getAnalogSensor(), getServoAngle(), getSakaAngle() );
        }
        return;
    }

    /* XCb`4@ݒlۑ */
    if( getSwFlag(SW_4) ) {
        // p[^ۑ
        writeDataFlashParameter();
        setBeepPatternS( 0x8800 );
    }

    /* XCb`3@j[{P */
    if( getSwFlag(SW_3) ) { 
        lcd_pattern++;
        if( lcd_pattern == 4 ) lcd_pattern = 1;
    }

    /* XCb`2@j[|P */
    if( getSwFlag(SW_2) ) {
        lcd_pattern--;
        if( lcd_pattern == 0 ) lcd_pattern = 3;
    }

    /* LCDAXCb` */
    switch( lcd_pattern ) {
    case 1:
        /* ݒ */
        i = data_buff[DF_KYORI];
        if( getSwFlag(SW_1) ) {
            i++;
            if( i > 100 ) i = 100;
        }
        if( getSwFlag(SW_0) ) {
            i--;
            if( i < 1 ) i = 1;
        }
        data_buff[DF_KYORI] = i;

        /* LCD */
        lcdPosition( 0, 0 );
                 /* 0123456789abcdef 1s16 */
        lcdPrintf( "01 ò = %3dm", i );
                 /* 01.4567.bcdef 1s16 */
        lcdPrintf( "%04d %05d %3d",
                    getServoAngle(), getAnalogSensor(), getSakaAngle() );
        
        break;

    case 2:
        /* p^[PP̃GR[_lݒ */
        i = data_buff[DF_P11_ENC];
        if( getSwFlag(SW_1) ) {
            i++;
            if( i > 127 ) i = 127;
        }
        if( getSwFlag(SW_0) ) {
            i--;
            if( i < 0 ) i = 0;
        }
        data_buff[DF_P11_ENC] = i;

        /* LCD */
        lcdPosition( 0, 0 );
                 /* 0123456789abcdef 1s16 */
        lcdPrintf( "02 P11Enc = %3d ", i*5 );
                 /* 01234567 8 9abcd ef 1s16 */
        lcdPrintf( "sensor=%x%x bar=%d ",
                    center_inp(), sensor_inp(), startbar_get() );
        break;

    case 3:
        /* p^[PP̊pxP@ݒ */
        i = data_buff[DF_P11_ANG1];
        if( getSwFlag(SW_1) ) {
            i++;
            if( i > 127 ) i = 127;
        }
        if( getSwFlag(SW_0) ) {
            i--;
            if( i < 0 ) i = 0;
        }
        data_buff[DF_P11_ANG1] = i;

        /* LCD */
        lcdPosition( 0, 0 );
                 /* 0123456789abcdef 1s16 */
        lcdPrintf( "03 P11Ang1= %3d ", i );
                 /* 01234567 89abcd ef 1s16 */
        lcdPrintf( "sensor=%x%x bar=%d ",
                    center_inp(), sensor_inp(), startbar_get() );
        break;
        
    default:
        lcd_pattern = 1;
        break;
    }
}

/************************************************************************/
/* ⓹`FbN                                                         */
/* @ Ȃ                                                          */
/* ߂l Ȃ                                                          */
/* @ ⓹Ɣfsaka_flag = 1 ⓹łȂȂ 0                */
/************************************************************************/
void sakaSyori( void )
{
    // ̊mFled_outŃp^[\AmFIRgɂ
#if 0
    led_out( ((saka_pattern/10)<<4) | (saka_pattern%10) );
#endif

    switch( saka_pattern ) {
    case 0:
        // Ã`FbN
        if( getSakaAngle() <= -15 ) {  // A/DlȂ
            cnt_saka = 0;
            saka_pattern = 1;               // ⏈
        }
        break;
    case 1:
        // @ԂāAēx`FbN
        if( cnt_saka >= 10 ) {
            if( getSakaAngle() <= -15 ) {  // 
                setBeepPatternS( 0xcc00 );
                saka_flag = 1;                  // tOON!
                cnt_saka = 0;
                saka_pattern = 2;
            } else {
                // ȂȂ듮ƔfĖ߂
                saka_pattern = 0;
            }
        }
        break;
    case 2:
        // @_̒Ԃ炢Ĩ`FbN
        if( cnt_saka >= 500 ) {
            cnt_saka = 0;
            saka_pattern = 3;
        }
        break;
    case 3:
        // @̒_`FbN
        if( getSakaAngle() >= 15 ) {
            cnt_saka = 0;
            saka_pattern = 4;
        }
        break;
    case 4:
        // @ԂāAēx`FbN
        if( cnt_saka >= 10 ) {
            if( getSakaAngle() >= 15 ) {   // 
                setBeepPatternS( 0xff00 );
                saka_flag = 0;                  // tOOFF!
                cnt_saka = 0;
                saka_pattern = 5;
            } else {
                // ȂȂ듮ƔfĖ߂
                saka_pattern = 3;
            }
        }
        break;
    case 5:
        // I@΂炭⃂[hɂ͓Ȃ
        if( cnt_saka >= 5000 ) {
            cnt_saka = 0;
            saka_pattern = 0;
        }
        break;
    }
}

/************************************************************************/
/* end of file                                                          */
/************************************************************************/

/*
e

Ver.2.01 2013.07.03 vO
Ver.2.02 2015.06.01 servoPwmOut֐̃~bgp^[11ȏɂ
Ver.3.00 2023.08.15 Advanced}CRJ[}jAŐ삵
                    }CRJ[pɉ
*/