/****************************************************************************/
/* Ώۃ}CR R8C/38A                                                     */
/* ̧ٓe     f[^tbV                                        */
/* o[W   Ver.1.03                                                    */
/* Date         2011.04.01                                                  */
/* Copyright    Wp}CRJ[[sψ                        */
/****************************************************************************/

/*======================================*/
/* CN[h                         */
/*======================================*/
#include    "sfr_r838a.h"               /* R8C/38A SFR̒`t@C    */
#include    "data_flash_lib.h"          /* f[^tbVCu   */

/*======================================*/
/* V{`                         */
/*======================================*/
/* f[^tbV֌W */
#define DF_SELECT_A 0                   /* ubNAI                */
#define DF_SELECT_B 1                   /* ubNBI                */
#define DF_SELECT_C 2                   /* ubNCI                */
#define DF_SELECT_D 3                   /* ubNDI                */

/*======================================*/
/* vg^Cv錾([J)           */
/*======================================*/
int clrStatusRegister( unsigned int c_address );
int checkBlockAddress( unsigned int chk_address );

/************************************************************************/
/* W[ readDataFlash                                           */
/* Tv     f[^tbVǂݍ                                */
/*          unsigned int    ǂݍ݌AhX 0x3000-0x3fff        */
/*              char*           ǂݍݐAhX                      */
/*              int             ǂݍރf[^                        */
/* ߂l       Ȃ                                                    */
/************************************************************************/
void readDataFlash( unsigned int r_address, signed char *w_address, int count )
{
    if( count >= 1 && count <= 4096 ) {
        while( count-- ) {
            *w_address = *((signed char*)r_address);
            w_address++;
            r_address++;
        }
    }
}

/************************************************************************/
/* W[ blockEraseDataFlash                                     */
/* Tv     ubNC[Y                                        */
/*          unsinged int    AhX                                */
/* ߂l       1:G[Ȃ 0:G[                               */
/*          135msx                                         */
/************************************************************************/
int blockEraseDataFlash( unsigned int address )
{
    volatile int ret = 1;
    volatile int block;

    block = checkBlockAddress( address );
    if( block == -1 ) return 0;

    asm( "FCLR I" );                    /* Ŝ̊荞݋֎~           */

    fmr01 = 0;                          /* CPU[hɐݒ      */
    asm(" ");                           /* œK}                   */
    fmr01 = 1;
    fmr02 = 0;                          /* EW1[hI                */
    asm(" ");                           /* œK}                   */
    fmr02 = 1;
    cmderie = 0;                        /* ڰ/ײĴװ荞݋֎~     */
    bsyaeie = 0;                        /* ׯװ荞݋֎~     */
    rdystie = 0;                        /* ׯިð荞݋֎~   */

    /* ްׯۯ֎~rbgɂ */
    switch( block ) {
        case DF_SELECT_A:
            fmr14 = 1;
            asm(" ");
            fmr14 = 0;                  /* ۯA ĳގt\   */
            break;
        case DF_SELECT_B:
            fmr15 = 1;
            asm(" ");
            fmr15 = 0;                  /* ۯB ĳގt\   */
            break;
        case DF_SELECT_C:
            fmr16 = 1;
            asm(" ");
            fmr16 = 0;                  /* ۯC ĳގt\   */
            break;
        case DF_SELECT_D:
            fmr17 = 1;
            asm(" ");
            fmr17 = 0;                  /* ۯD ĳގt\   */
            break;
    }

    fmr20 = 0;                          /* ڰ޻(ES)֎~         */
    fmr22 = 0;                          /* 荞ݗvESظċ֎~    */
    fmr27 = 0;                          /* dذӰދ֎~       */

    /* ubNC[Y */
    *((char *)address) = 0x20;          /* ubNC[YR}h     */
    *((char *)address) = 0xd0;
    while( fst7 == 0 );                 /* ҂                     */

    ret = clrStatusRegister( address );

    *((char *)address) = 0xff;          /* f[^tbVǂݍݏ */

    /* ްׯۯ֎~rbg֎~ɂ */
    switch( block ) {
        case DF_SELECT_A:
            fmr14 = 1;
            break;
        case DF_SELECT_B:
            fmr15 = 1;
            break;
        case DF_SELECT_C:
            fmr16 = 1;
            break;
        case DF_SELECT_D:
            fmr17 = 1;
            break;
    }
    fmr01 = 0;                          /* CPU[h        */

    asm( "FSET I" );                    /* Ŝ̊荞݋           */

    return ret;
}

/************************************************************************/
/* W[ writeDataFlash                                          */
/* Tv     vO()                                */
/*          unsigned int    ݌AhX 0x3000-0x3fff        */
/*              char*           ݐAhX                      */
/*              int             ރf[^                        */
/* ߂l       1:G[Ȃ 0:G[                               */
/*          64oCg݂9.5ms                           */
/************************************************************************/
int writeDataFlash( unsigned int w_address, signed char *r_address, int count )
{
    volatile int ret = 1, i;
    volatile int block, block2;

    // JnAhX̃`FbN
    block = checkBlockAddress( w_address );
    if( block == -1 ) return 0;

    // IAhX̃`FbN
    block2 = checkBlockAddress( w_address + count - 1 );
    if( block2 == -1 ) return 0;

    // ubN`FbN
    if( block != block2 ) return 0;

    asm( "FCLR I" );                    /* Ŝ̊荞݋֎~           */

    fmr01 = 0;                          /* CPU[hɐݒ      */
    asm(" ");                           /* œK}                   */
    fmr01 = 1;
    fmr02 = 0;                          /* EW1[hI                */
    asm(" ");                           /* œK}                   */
    fmr02 = 1;
    cmderie = 0;                        /* ڰ/ײĴװ荞݋֎~     */
    bsyaeie = 0;                        /* ׯװ荞݋֎~     */
    rdystie = 0;                        /* ׯިð荞݋֎~   */

    /* ްׯۯ֎~rbgɂ */
    switch( block ) {
        case DF_SELECT_A:
            fmr14 = 1;
            asm(" ");
            fmr14 = 0;                  /* ۯA ĳގt\   */
            break;
        case DF_SELECT_B:
            fmr15 = 1;
            asm(" ");
            fmr15 = 0;                  /* ۯB ĳގt\   */
            break;
        case DF_SELECT_C:
            fmr16 = 1;
            asm(" ");
            fmr16 = 0;                  /* ۯC ĳގt\   */
            break;
        case DF_SELECT_D:
            fmr17 = 1;
            asm(" ");
            fmr17 = 0;                  /* ۯD ĳގt\   */
            break;
    }

    fmr20 = 0;                          /* ڰ޻(ES)֎~         */
    fmr22 = 0;                          /* 荞ݗvESظċ֎~    */
    fmr27 = 0;                          /* dذӰދ֎~       */

    /* vO */
    while( count-- ) {
        *((signed char *)w_address) = 0x40;
        *((signed char *)w_address) = *r_address;
        while( fst7 == 0 );             /* ҂                     */

        ret = clrStatusRegister( w_address );
        if( ret == 0 ) break;
        w_address++;
        r_address++;
    }

    *((unsigned char*)(w_address-1)) = 0xff;  /* ްׯǂݍݏ  */

    /* ްׯۯ֎~rbg֎~ɂ */
    switch( block ) {
        case DF_SELECT_A:
            fmr14 = 1;
            break;
        case DF_SELECT_B:
            fmr15 = 1;
            break;
        case DF_SELECT_C:
            fmr16 = 1;
            break;
        case DF_SELECT_D:
            fmr17 = 1;
            break;
        default:
            break;
    }
    fmr01 = 0;                          /* CPU[h        */

    asm( "FSET I" );                    /* Ŝ̊荞݋           */

    return ret;
}

/************************************************************************/
/* W[ clrStatusRegister                                       */
/* Tv     NAXe[^XWX^                                */
/*          AhX                                                */
/* ߂l       1:G[Ȃ 0:G[                               */
/************************************************************************/
int clrStatusRegister( unsigned int c_address )
{
    volatile int ret = 1;

    if( fst5 == 1 || fst4 == 1 ) {
        *((char*)c_address) = 0x50;
        ret = 0;
    }

    return ret;
}

/************************************************************************/
/* W[ checkBlockAddress                                       */
/* Tv     ubNAhX̃`FbN                              */
/*          ƂĂAhX                            */
/* ߂l       -1: G[ 0-3:ubNNo                               */
/************************************************************************/
int checkBlockAddress( unsigned int chk_address )
{
    volatile int ret = -1;

    /* ubN`FbN */
    if( chk_address >= 0x3000 && chk_address <= 0x33ff ) {
        ret = DF_SELECT_A;
    } else if( chk_address >= 0x3400 && chk_address <= 0x37ff ) {
        ret = DF_SELECT_B;
    } else if( chk_address >= 0x3800 && chk_address <= 0x3bff ) {
        ret = DF_SELECT_C;
    } else if( chk_address >= 0x3c00 && chk_address <= 0x3fff ) {
        ret = DF_SELECT_D;
    }

    return ret;
}

/************************************************************************/
/* end of file                                                          */
/************************************************************************/

/*
o

2010.04.01 Ver.1.00 쐬
2011.03.18 Ver.1.02 writeDataFlash֐́AC[YȂ悤ɏC
2011.04.01 Ver.1.03 ϐvolatile̒ǉ
*/
