/****************************************************************************/
/* Ώۃ}CR R8C/38A                                                     */
/* ̧ٓe     I2CɂEEP-ROM(24C256B)                               */
/* o[W   Ver.1.04                                                    */
/* Date         2017.02.17                                                  */
/* Copyright    Wp}CRJ[[sψ                        */
/****************************************************************************/

/*======================================*/
/* CN[h                         */
/*======================================*/
#include    "sfr_r838a.h"               /* R8C/38A SFR̒`t@C    */
#include    "i2c_eeprom_lib.h"          /* EEP-ROM֘A              */

/*======================================*/
/* V{`                         */
/*======================================*/

/* setPageWriteI2CEeprom֐PŕۑoTCY */
#define EEP_SAVE_SIZE       16          /* őۑ                   */

/* ̑` */
#define ACK                 0           /* [hACKL(ACK=0)     */
#define NO_ACK              1           /* [hACK(ACK=1)     */

#define STOP_RD             0           /* Xgbv̒O͓ǂݍ     */
#define STOP_WR             1           /* Xgbv̒O͏     */

/*======================================*/
/* O[oϐ̐錾                 */
/*======================================*/

static volatile unsigned char   eep_address;
                                        /* AhX̑I               */
static volatile int             write_mode;
                                        /* e                     */
static volatile unsigned char   write_eep_address;
                                        /* EEP-ROM̃AhX    */
static volatile unsigned int    write_address;
                                        /* ݃AhX             */
static volatile int             write_count;
                                        /* ݌                 */
static volatile signed char     write_buff[EEP_SAVE_SIZE];
                                        /* ݃f[^ۑobt@   */
static volatile signed char     *write_buff_p;
                                        /* ݃f[^ǂݍ݈ʒu   */

/*======================================*/
/* vg^Cv錾                     */
/*======================================*/

/************************************************************************/
/* W[ i2c_start                                               */
/* Tv     X^[g֘AWX^ݒAX^[gMM              */
/************************************************************************/
int i2c_start( void )
{
    int i = 50;

    stop_icsr = 0;
    while( --i ) {
        if( bbsy_iccr2 != 1 ) break;
    }
    iccr1 |= 0x30;                      /* }X^M[h             */
    iccr2 = 0x90;                       /* X^[gs             */

    return i;
}

/************************************************************************/
/* W[ i2c_stop                                                */
/* Tv     XgbvMM                                        */
/************************************************************************/
int i2c_stop( int mode )
{
    int i = 50;

    if( mode == STOP_WR ) {
        iccr2 = 0x10;                   /* Xgbvs             */
        tend_icsr = 0;
        nackf_icsr = 0;
        while( --i ) {
            if( stop_icsr != 0 ) break;
        }
        stop_icsr = 0;
    }
    iccr1 &= 0xcf;                      /* X[uM[h           */

    return i;
}

/************************************************************************/
/* W[ i2c_write                                               */
/* Tv     EEP-ROM@PoCg                               */
/*          signed char f[^                                      */
/* ߂l       int  acknowledge 0:L  1: -1:ڑG[           */
/************************************************************************/
int i2c_write( signed char data )
{
    int ret, i;

    icdrt = data;

    i = 50;
    while( --i ) {
        if( tdre_icsr != 0 ) break;
    }

    if( i == 0 ) goto i2c_write_Exit;

    i = 100;
    while( --i ) {
        if( tend_icsr != 0 ) break;
    }

i2c_write_Exit:
    ret = ((i == 0) ? -1 : ackbr_icier);

    return ret;
}

/************************************************************************/
/* W[ i2c_read                                                */
/* Tv     EEP-ROM@PoCgǂݍ                               */
/*          int ACKFf[^ NO_ACKFf[^I                */
/* ߂l       signed char f[^                                      */
/************************************************************************/
signed char i2c_read( int ack )
{
    signed char ret;
    int i;

    tend_icsr = 0;
    iccr1 &= 0xef;
    tdre_icsr = 0;
    ackbt_icier = 1;
    ret = icdrr;                        /* _~[[h                 */

    if( ack == NO_ACK ) {
        rcvd_iccr1 = 1;                 /* ̎M֎~           */
    }

    i = 100;
    while( --i ) {
        if( rdrf_icsr != 0 ) break;
    }

    if( i == 0 ) goto i2c_read_Exit;

    iccr2 = 0x10;

    i = 100;
    while( --i ) {
        if( stop_icsr != 0 ) break;
    }

i2c_read_Exit:
    ret = (i == 0 ) ? 0x00 : icdrr;

    rcvd_iccr1 = 0;
    ackbt_icier = 0;

    return ret;
}

/************************************************************************/
/* W[ initI2CEeprom                                           */
/* Tv     EEP-ROM̃|[g                                   */
/*          Ȃ                                                    */
/* ߂l       Ȃ                                                    */
/************************************************************************/
void initI2CEeprom( void )
{
    pd3 &= 0x5f;                        /* P3_7:SDA P3_5:SCL            */

    iicsel = 1;
    stop_icsr = 0;
    ice_iccr1 = 1;
    icmr  = 0x00;
    iccr1 = 0x82;
    icier = 0x00;
    icsr  = 0x00;
    sar   = 0x00;

    selectI2CEepromAddress( 0 );        /* AhX̑I               */
    write_mode  = 0;
}

/************************************************************************/
/* W[ selectI2CEepromAddress                                  */
/* Tv     ǂ̔ԍEEP-ROMgp邩I                       */
/*          unsigned char EEP-ROM̃AhX 0`3                    */
/* ߂l       Ȃ                                                    */
/************************************************************************/
void selectI2CEepromAddress( unsigned char address )
{
    address &= 0x03;
    eep_address = address << 1;
}

/************************************************************************/
/* W[ readI2CEeprom                                           */
/* Tv     EEP-ROMǂݍ                                         */
/*          unsigned long   AhX 0-32767                        */
/* ߂l       signed char     f[^                                  */
/************************************************************************/
signed char readI2CEeprom( unsigned long address )
{
    signed char ret;

    asm( "FCLR I" );                    /* Ŝ̊荞݋֎~           */

    i2c_start();
    i2c_write( 0xa0 | eep_address );    /* device address(write)        */
    i2c_write( (address >> 8) & 0xff ); /* first address                */
    i2c_write( address & 0xff );        /* second address               */
    iccr2 = 0x90;                       /* X^[gđ                 */
    i2c_write( 0xa1 | eep_address );    /* device address(read)         */
    ret = i2c_read( NO_ACK );           /* data read                    */
    i2c_stop( STOP_RD );

    asm( "FSET I" );                    /* Ŝ̊荞݋           */

    return ret;
}

/************************************************************************/
/* W[ writeI2CEeprom                                          */
/* Tv     EEP-ROM                                         */
/*          unsigned long AhX 0-32767 ,signed char f[^      */
/* ߂l       Ȃ                                                    */
/************************************************************************/
void writeI2CEeprom( unsigned long address, signed char write )
{
    int i;

    asm( "FCLR I" );                    /* Ŝ̊荞݋֎~           */

    i2c_start();
    i2c_write( 0xa0 | eep_address );    /* device address(write)        */
    i2c_write( (address >> 8) & 0xff ); /* first address                */
    i2c_write( address & 0xff );        /* second address               */
    i2c_write( write );                 /* data write                   */
    i2c_stop( STOP_WR );

    asm( "FSET I" );                    /* Ŝ̊荞݋           */
}

/************************************************************************/
/* W[ setPageWriteI2CEeprom                                   */
/* Tv     EEP-ROMy[W                                   */
/*              ̊֐Ńy[W݂Jn                      */
/*          unsigned long AhX 0-32767 , int ,              */
/*              signed char* f[^AhX                       */
/* ߂l       Ȃ                                                    */
/************************************************************************/
void setPageWriteI2CEeprom(
                unsigned long address, int count, signed char* data )
{
    /* ݒȂ炱̊֐͒~ */
    if( write_mode != 0 ) return;

    write_mode          = 1;
    write_eep_address   = eep_address;
    write_address       = address;
    write_count         = count;
    write_buff_p        = write_buff;

    if( count >= EEP_SAVE_SIZE ) count = EEP_SAVE_SIZE;
    do {
        *write_buff_p++ = *data++;
    } while( --count );

    write_buff_p = write_buff;
}

/************************************************************************/
/* W[ I2CEepromProcess                                        */
/* Tv     EEP-ROMy[W                                   */
/*          Ȃ                                                    */
/* ߂l       Ȃ                                                    */
/************************************************************************/
void I2CEepromProcess( void )
{
    int i;

    // ڑG[ȂAȂ
    if( write_mode == 99 ) return;
    
    asm( "FCLR I" );                    /* Ŝ̊荞݋֎~           */

    switch( write_mode ) {
    case 1:
        i = i2c_start();
        write_mode = ((i != 0) ? 2 : 99);
        break;
    case 2:
        i = i2c_write( 0xa0 | write_eep_address );  /* device address(write)*/
        write_mode = ((i != -1) ? 3 : 99);
        break;
    case 3:
        i = i2c_write( (write_address >> 8) & 0xff );   /* first address    */
        write_mode = ((i != -1) ? 4 : 99);
        break;
    case 4:
        i = i2c_write( write_address & 0xff );      /* second address       */
        write_mode = ((i != -1) ? 5 : 99);
        break;
    case 5:
        i = i2c_write( *write_buff_p++ );           /* data write           */
        if( i == -1 ) write_mode = 99;
        else if( !(--write_count) ) write_mode = 6;
        break;
    case 6:
        i2c_stop( STOP_WR );
        write_mode = 0;
        break;
    }

    asm( "FSET I" );                    /* Ŝ̊荞݋           */
}

/************************************************************************/
/* W[ clearI2CEeprom                                          */
/* Tv     EEP-ROM@I[NA                                   */
/*          char* NAɃj^LED̃|[g                   */
/*              int   NAɃj^LED̃rbg                   */
/* ߂l       Ȃ                                                    */
/************************************************************************/
void clearI2CEeprom( char *led_port , int bit )
{
    unsigned int    address = 0;
    int             i, loop;

    //asm( "FCLR I" );                    /* Ŝ̊荞݋֎~           */

    while( address < 32768 ) {
        if( !(address % 0x800) ) *led_port ^= (1<<bit);

        i2c_start();
        i2c_write( 0xa0 | eep_address ); /* device address(write)       */
        i2c_write( address >> 8 );      /* first address                */

        i2c_write( address & 0xff );    /* second address               */
        for( loop=0; loop<64; loop++ ) {
            i = i2c_write( 0 );         /* data write                   */
            if( i == -1 ) goto clearI2CEeprom_Error;  // ڑG[
        }
        i2c_stop( STOP_WR );

        i = 1000;
        while( --i ) {                  /* ݂I`FbN */
            if( checkI2CEeprom() != 0 ) break;
        }

        address += 64;
    }

    goto clearI2CEeprom_End;

clearI2CEeprom_Error:
    write_mode = 99;

clearI2CEeprom_End:
    asm( "FSET I" );                    /* Ŝ̊荞݋           */
}

/************************************************************************/
/* W[ checkI2CEeprom                                          */
/* Tv     EEP-ROM݌Aɓǂݏł邩`FbN         */
/*          Ȃ                                                    */
/* ߂l       1:ǂݏOK 0:܂                                   */
/************************************************************************/
int checkI2CEeprom( void )
{
    int ret;

    if( write_mode != 0 ) return 0;

    asm( "FCLR I" );                    /* Ŝ̊荞݋֎~           */

    i2c_start();
    ret = !i2c_write( 0xa0 | eep_address ); /* device address(write)    */
    i2c_stop( STOP_WR );

    asm( "FSET I" );                    /* Ŝ̊荞݋           */

    return ret;
}

/************************************************************************/
/* W[ endI2CEeprom                                            */
/* Tv     EEP-ROMI                                         */
/*          Ȃ                                                    */
/* ߂l       Ȃ                                                    */
/************************************************************************/
void endI2CEeprom( void )
{
    int i = 0;
    
    while( checkI2CEeprom == 0 ) {          // Ȃ҂
    } 
    write_mode = 0; // ڑ
}

/************************************************************************/
/* end of file                                                          */
/************************************************************************/

/*
o

2010.04.01 Ver.1.00 쐬
2011.04.01 Ver.1.01 ϐvolatileǉ
2011.08.13 Ver.1.02 EEP-ROMɕۑf[^^char^unsigned char^ɕύX
2016.09.25 Ver.1.03 ^CAEgǉ
2017.02.17 Ver.1.04 endI2CEeprom֐ǉ
