/****************************************************************************/
/* Ώۃ}CR R8C/38A                                                     */
/* ̧ٓe     t䃉Cu                                          */
/* o[W   Ver.1.03                                                    */
/* Date         2023.08.14                                                  */
/* Copyright    Wp}CRJ[[sψ                        */
/****************************************************************************/

/*======================================*/
/* CN[h                         */
/*======================================*/
#include    <stdio.h>                   /* WCײ o           */
#include    <stdarg.h>                  /* WCײ ό̎ */
#include    "sfr_r838a.h"               /* R8C/38A SFR̒`t@C    */
#include    "lcd_lib.h"                 /* t֘A                 */

/*======================================*/
/* V{`                         */
/*======================================*/
/*
tEmicroSD̉tڑ|[g
P5_7    P5_6    P5_5    P5_4    P5_3    P5_2    P5_1    P5_0
gp  E       RW      RS      D7      D6      D5      D4
D7`D4́AK|[gbit3`0ɐڑ܂B
*/

/* t̃|[gArbgzu */
#define LCD_PORT            p5          /* t̐ڑĂ|[g   */
#define LCD_PORT_DIR        pd5         /* L|[g̓o͐ݒ|[g */
#define LCD_PORT_PULLUP     pu12        /* D7[qvAbv郌WX^*/

#define LCD_NODATA_BIT      0x80        /* tŎgĂȂrbg     */
#define LCD_E_BIT           0x40        /* t E bit                   */
#define LCD_RW_BIT          0x20        /* t RW bit                  */
#define LCD_RS_BIT          0x10        /* t RS bit                  */
#define LCD_D7_BIT          0x08        /* t D7 bit                  */

/* t֘Aϐ */
#define LCD_MAX_X           16          /* \  16 or 20       */
#define LCD_MAX_Y           2           /* \ c  2 or  4       */

/* tR[h */
#define LCD_INST            0x00        /* CXgNV           */
#define LCD_DATA            LCD_RS_BIT  /* f[^                       */

/*======================================*/
/* O[oϐ̐錾                 */
/*======================================*/
static volatile char            buffLcdData[ LCD_MAX_X * LCD_MAX_Y ];
                                        /* \obt@                 */
static volatile char            buffLcdData2[ LCD_MAX_X * LCD_MAX_Y + 10 ];
                                        /* \obt@ꎞƃGA   */
static volatile int             lcdBuffPosition;
                                        /* obt@ɏވʒu       */
static volatile int             lcdMode = 1;
                                        /* \NoǗ               */
static volatile int             lcdNowLocate;
                                        /* ݂̕\Ăʒu       */
static volatile unsigned long   lcdBusyCnt;
                                        /* busyX^[gJE^         */
static volatile int             lcdRefreshFlag;
                                        /* tbVtO           */
static volatile int             lcdConnect = 1;
                                        /* tڑĂ邩       */
static volatile unsigned long   lcdCnt; /* t^C~OpJE^     */

/************************************************************************/
/* ^C}                                                               */
/* ɒZ^C~Op^C} 11us炢                            */
/************************************************************************/
static void lcd_nop( volatile int i )
{
    while( i-- );
}

/************************************************************************/
/* ^C}                                                               */
/* @ ^C}l 1=1ms                                                */
/************************************************************************/
static void lcdTimer( unsigned long timer_set )
{
    volatile unsigned long t;

    t = lcdCnt;

    while( lcdCnt - t < timer_set );
}

/************************************************************************/
/* W[ lcdBusyStart                                            */
/* Tv     tbusyX^[g                                      */
/*          busyl                                                  */
/* ߂l       Ȃ                                                    */
/************************************************************************/
static void lcdBusyStart( void )
{
    lcdBusyCnt = lcdCnt;
}

/************************************************************************/
/* W[ lcdOut2                                                 */
/* Tv     lcdOut̏ʁAʂɕē]镔                  */
/*          4bitf[^                                              */
/* ߂l       Ȃ                                                    */
/************************************************************************/
static void lcdOut2( char data2 )
{
    volatile unsigned char b;

    LCD_PORT = LCD_PORT & LCD_NODATA_BIT | data2;
    lcd_nop(1);
    LCD_PORT |= LCD_E_BIT;
    lcd_nop(5);
    LCD_PORT &= ~LCD_E_BIT;
    lcd_nop(5);
}

/************************************************************************/
/* W[ lcdOut                                                  */
/* Tv     tR}ho                                        */
/*          R}hށAf[^                                    */
/* ߂l       Ȃ                                                    */
/************************************************************************/
static void lcdOut( char command, char data )
{
    volatile unsigned char work;

    /* 4bit] */
    work = (unsigned char)command | ((unsigned char)data >> 4);
    lcdOut2( work );

    /* 4bit] */
    work = (unsigned char)command | ((unsigned char)data & 0x0f);
    lcdOut2( work );
}

/************************************************************************/
/* W[ lcdLocate                                               */
/* Tv     tJ[\ړ                                        */
/*          x , y                                                   */
/* ߂l       Ȃ                                                    */
/************************************************************************/
static void lcdLocate( int x, int y )
{
    volatile unsigned char work = 0x80;

    /* x̌vZ */
    work += x;

    /* y̌vZ */
    if( y == 1 ) {
        work += 0x40;
    } else if( y == 2 ) {
        work += 0x14;
    } else if( y == 3 ) {
        work += 0x54;
    }

    /* J[\ړ */
    lcdOut( LCD_INST, work );
    lcdBusyStart();
}

/************************************************************************/
/* W[ checkLcdBusy                                            */
/* Tv     tbusy`FbN                                      */
/*          Ȃ                                                    */
/* ߂l       2:^CAEg 1:ok 0:busy                            */
/************************************************************************/
static int checkLcdBusy( void )
{
    volatile int ret;

    /* D3`D0͒[qɂ */
    LCD_PORT_PULLUP = 1;
    LCD_PORT_DIR   &= 0xf0;

    LCD_PORT &= ( ~LCD_E_BIT & ~LCD_RW_BIT & ~LCD_RS_BIT );

    LCD_PORT |= LCD_RW_BIT;
    lcd_nop(1);

    LCD_PORT |= LCD_E_BIT;
    lcd_nop(5);

    ret = (LCD_PORT & LCD_D7_BIT) ? 0 : 1;
    if( ret == 0 ) {
        /* busyȂA^CAEg`FbN */
        if( lcdCnt - lcdBusyCnt >= 11 ) ret = 2;
    }

    LCD_PORT &= ~LCD_E_BIT;
    lcd_nop(5);

    LCD_PORT |= LCD_E_BIT;              /* 4bit[hȂ̂             */
    lcd_nop(5);                         /* _~[E bitĂ          */

    LCD_PORT &= ~LCD_E_BIT;
    lcd_nop(5);

    LCD_PORT &= ~LCD_RW_BIT;

    /* D3`D0o͒[qɂ */
    LCD_PORT_PULLUP = 0;
    LCD_PORT_DIR   |= 0x0f;

    return ret;
}

/************************************************************************/
/* W[ initLcd                                                 */
/* Tv     t@                                        */
/*          Ȃ                                                    */
/* ߂l       0:ُ 1:                                           */
/************************************************************************/
int initLcd( void )
{
    volatile int i;

    /* E,RW,RS,D3`D0o͒[qɂ */
    LCD_PORT_PULLUP = 0;
    LCD_PORT_DIR   |= (0x0f | LCD_E_BIT | LCD_RW_BIT | LCD_RS_BIT);

    for( i=0; i<=LCD_MAX_X*LCD_MAX_Y-1; i++ ) { /* ϐ           */
        buffLcdData[ i ] = ' ';
    }

    lcdTimer( 15 );                     /* 15msȏ̃^C}             */

    lcdOut2( 0x03 );                    /* ̧ݸݾ 8bit            */
    lcdTimer( 5 );                      /* 4.1msȏ̃^C}            */

    lcdOut2( 0x03 );                    /* ̧ݸݾ 8bit            */
    lcdTimer( 2 );                      /* 100usȏ̃^C}            */

    lcdOut2( 0x03 );                    /* ̧ݸݾ 8bit            */
    lcdBusyStart();
    while( !(i = checkLcdBusy()) );
    if( i == 2 ) {
        lcdConnect = 0;
        return 0;                       /* G[I                   */
    }

    lcdOut2( 0x02 );                    /* ̧ݸݾ 4bit            */
    lcdBusyStart();
    while( !checkLcdBusy() );

    lcdOut( LCD_INST, 0x28 );           /* 1sAfont:5*7ݒ            */
    lcdBusyStart();
    while( !checkLcdBusy() );

    lcdOut( LCD_INST, 0x08 );           /* \offݒ                  */
    lcdBusyStart();
    while( !checkLcdBusy() );

    lcdOut( LCD_INST, 0x01 );           /* \NA                   */
    lcdBusyStart();
    while( !checkLcdBusy() );

    lcdOut( LCD_INST, 0x06 );           /* ݸĂA\Ė     */
    lcdBusyStart();
    while( !checkLcdBusy() );

    lcdOut( LCD_INST, 0x0c );           /* \ON                       */
    lcdBusyStart();
    while( !checkLcdBusy() );

    return 1;
}

/************************************************************************/
/* W[ lcdShowProcess                                          */
/* Tv     t\                                            */
/*          Ȃ                                                    */
/* ߂l       Ȃ                                                    */
/*          ̊֐͊荞݂1msƂɎsĂ           */
/************************************************************************/
void lcdShowProcess( void )
{
    if( !lcdConnect ) return;          /* ڑĂ邩`FbN  */

    lcdCnt++;

    switch( lcdMode ) {
    case 1: /* f[^XVꂽ`FbN */
        if( lcdRefreshFlag ) {
            lcdRefreshFlag = 0;
            lcdMode = 2;
        }
        break;

    case 2: /* ʒu*/
        if( checkLcdBusy() ) {
            lcdNowLocate = 0;
            lcdLocate( 0, 0 );
            lcdMode = 3;
        }
        break;

    case 3: /* sʒůmF */
        if( checkLcdBusy() ) {
            if( lcdNowLocate % LCD_MAX_X == 0 ) {
                lcdLocate( 0, lcdNowLocate / LCD_MAX_X );
            }
            lcdMode = 4;
        }
        break;

    case 4: /* f[^\ */
        if( checkLcdBusy() ) {
            lcdOut( LCD_DATA, buffLcdData[ lcdNowLocate++ ] );
            lcdBusyStart();
            if( lcdNowLocate >= LCD_MAX_X * LCD_MAX_Y ) {
                lcdMode = 1;
            } else {
                lcdMode = 3;
            }
        }
        break;

    default:
        lcdMode = 1;
        break;
    }
    pd5 &= 0xf0;                        /* LCDƌp̒[q͂ɐݒ  */
}

/************************************************************************/
/* W[ lcdPrintf                                               */
/* Tv     t֕\@\ʒu͉ߋɕ\ʒu̎        */
/*          printfƓ                                            */
/* ߂l       펞Fo͂@ُ펞F̐                  */
/************************************************************************/
int lcdPrintf(char *format, ...)
{
    volatile va_list argptr;
    volatile char    *p;
    volatile int     ret = 0;

    va_start(argptr, format);
    ret = vsprintf( buffLcdData2, format, argptr );
    va_end(argptr);

    if( ret > 0 ) {
        /* vsprintfȂtobt@֓] */
        p = buffLcdData2;
        while( *p ) {
            buffLcdData[lcdBuffPosition++] = *p++;
            if( lcdBuffPosition >= LCD_MAX_X * LCD_MAX_Y ) {
                lcdBuffPosition = 0;
            }
        }
        lcdRefreshFlag = 1;
    }
    return ret;
}

/************************************************************************/
/* W[ lcdPosition                                             */
/* Tv     t̕\ʒuw                                      */
/*          ʒu , cʒu                                         */
/* ߂l       Ȃ                                                    */
/************************************************************************/
void lcdPosition(char x ,char y)
{
    if( x >= LCD_MAX_X ) return;
    if( y >= LCD_MAX_Y ) return;

    lcdBuffPosition = x + y * LCD_MAX_X;
}

/************************************************************************/
/* end of file                                                          */
/************************************************************************/

/*
o

2011.04.01 Ver.1.00 쐬
2011.09.28 Ver.1.01 checkLcdBusy֐̃^CAEgC
2012.04.01 Ver.1.02 œKONɂĂ삷悤Ή
2023.08.14 Ver.1.03 initLcd֐
                    LCD_PORT_DIR   |= 0x0f;
                    
                    LCD_PORT_DIR   |= (0x0f | LCD_E_BIT | LCD_RW_BIT | LCD_RS_BIT);
                    ɕύX
*/
