/****************************************************************************/
/* Ώۃ}CR R8C/38A or R8C/38C                                          */
/* ̧ٓe     I2C(ST7032i)t䃉Cu                              */
/* o[W   Ver.1.20                                                    */
/* Date         2017.02.17                                                  */
/* Copyright    Wp}CRJ[[sψ                        */
/****************************************************************************/

/*======================================*/
/* CN[h                         */
/*======================================*/
#include <stdio.h>                      /* WCײ o           */
#include <stdarg.h>                     /* WCײ ό̎ */
#include "sfr_r838a.h"                  /* R8C/38A SFR̒`t@C    */
#include "lcd_st7032i_lib.h"            /* ST7032i(I2C)t\Cu */

/*======================================*/
/* V{`                         */
/*======================================*/

#define I2C_SFR             1           /* 1:}CRSFRgp          */
                                        /* 0:gpɃ|[gŏ     */
/*
1̏ꍇA[qŒ(P3_5P3_7)łA}CRׂ̕ȂȂ܂B
0̏ꍇARɒ[qIԂƂł܂A}CRׂ̕傫Ȃ
Bł邾A"1"ŎgpĂB

I2C_SFR = 1 ̂Ƃ̃|[gݒ
@P3_7:tSDA[q
@P3_5:tSCL[q
@ύX͂ł܂
*/

/* I2C_SFR = 0 ̂Ƃ̃|[gݒ |[g0͐ݒł܂ */
#define i2c_sda         p3_7            /* tSDA[q                */
#define i2c_sdaddr      pd3_7           /* tSDA[q̓o͐ݒڼ޽*/
#define i2c_scl         p3_5            /* tSCL[q                */
#define i2c_sclddr      pd3_5           /* tSCL[q̓o͐ݒڼ޽*/

/* I2C_SFR = 0 ̂ƂSDA[qASCL[q̐ݒ@ύXȂł */
#define i2c_SDA_0();    i2c_sda = 0;i2c_sdaddr = 1;     /* SDA = "0"    */
#define i2c_SDA_1();    i2c_sdaddr = 0;                 /* SDA = "1"    */
#define i2c_SCL_0();    i2c_scl = 0;i2c_sclddr = 1;     /* SCL = "0"    */
#define i2c_SCL_1();    i2c_sclddr = 0;                 /* SCL = "1"    */

/* \ */
#define LCD_MAX_X           8           /*   8 or 16 or 20      */
#define LCD_MAX_Y           2           /* c  1 or  2 or  4      */

/* tR[h */
#define LCD_INST            0x00        /* CXgNV           */
#define LCD_DATA            0x80        /* f[^                       */

/* ̑` */
#define ACK                 0           /* ACKL(ACK=0)               */
#define ACK_NO              1           /* ACK(ACK=1)               */
#define ACK_ERROR           2           /* ACK`FbNȂ̃G[*/

#define STOP_RD             0           /* Xgbv̒O͓ǂݍ     */
#define STOP_WR             1           /* Xgbv̒O͏     */

/*======================================*/
/* O[oϐ̐錾                 */
/*======================================*/
static volatile char            buffLcdData[ LCD_MAX_X * LCD_MAX_Y ];
                                        /* \obt@                 */
static volatile int             lcdBuffPosition;
                                        /* obt@ɏވʒu       */
static volatile int             lcdRefreshFlag;
                                        /* tbVtO           */
static volatile int             lcdMode;
                                        /* \NoǗ               */
static volatile unsigned long   lcdCnt;
                                        /* t^C~OpJE^     */
static volatile int             lcdCtrt = 25;
                                        /* t̔Z 0`63             */
                                        /* Zςꍇ͂     */
                                        /* lςĂ         */
static volatile int             lcdCtrt2;
                                        /* t̔Z rp            */
static volatile unsigned char   i2c_write_ret;
                                        /* I2C񂾌̕ԐMd    */

/************************************************************************/
/* W[ lcd_wait                                                */
/* Tv     Z^C}                                          */
/*          11usAœKIvV                  */
/*              RpC̃o[Wŕς邱Ƃ܂            */
/* ߂l                                                           */
/*          œKIvVRpC̃o[W              */
/*              Ԃς邱Ƃ܂                              */
/************************************************************************/
static void lcd_wait( volatile int i )
{
    while( i-- );
}

/************************************************************************/
/* W[ i2c_start                                               */
/* Tv     I2C X^[g֘AWX^ݒAX^[gMM          */
/*                                                              */
/* ߂l       0:ُ 1:                                           */
/************************************************************************/
static int i2c_start( void )
{
#if I2C_SFR
    int i = 1000, ret = 1;

    stop_icsr = 0;

    while( bbsy_iccr2 == 1 ) {
        if( !(i--) ) {
            ret = 0;
            break;
        }
    }

    iccr1 |= 0x30;                      /* }X^M[h             */
    iccr2  = 0x90;                      /* X^[gs             */

    return ret;
#else
    i2c_SDA_1();
    i2c_SCL_1();
    lcd_wait( 1 );

    i2c_SDA_0();
    i2c_SCL_1();
    lcd_wait( 1 );

    i2c_SDA_0();
    i2c_SCL_0();
    lcd_wait( 1 );

    return 1;
#endif
}

/************************************************************************/
/* W[ i2c_stop                                                */
/* Tv     I2C XgbvMM                                    */
/*          STOP_RD:stop̎O̓[h  STOP_WR:stop̎O̓Cg  */
/* ߂l       0:ُ 1:                                           */
/************************************************************************/
static int i2c_stop( int mode )
{
#if I2C_SFR
    int i = 1000, ret = 1;

    if( mode == STOP_WR ) {
        iccr2 = 0x10;                   /* Xgbvs             */
        tend_icsr = 0;
        nackf_icsr = 0;
        while( stop_icsr == 0 ) {
            if( !(i--) ) {
                ret = 0;
                break;                  /* ^CAEg             */
            }
        }
    }
    iccr1 &= 0xcf;                      /* X[uM[h           */

    return ret;
#else
    i2c_SDA_0();
    i2c_SCL_0();
    lcd_wait( 1 );

    i2c_SDA_0();
    i2c_SCL_1();
    lcd_wait( 1 );

    i2c_SDA_1();
    i2c_SCL_1();
    lcd_wait( 1 );

    return 1;
#endif
}

/************************************************************************/
/* W[ i2c_write                                               */
/* Tv     I2C@PoCg                                   */
/*          signed char f[^                                      */
/* ߂l                                                           */
/************************************************************************/
static void i2c_write( signed char data )
{
#if I2C_SFR
    icdrt = data;
#else
    int i;

    for( i = 0; i<8; i++ ) {
        /* data set */
        if( data & 0x80 ) {
            i2c_SDA_1();
        } else {
            i2c_SDA_0();
        }

        /* SCL ON */
        i2c_SCL_1();
        lcd_wait( 1 );

        /* SCL OFF  */
        i2c_SCL_0();
        lcd_wait( 1 );

        /* ̏ */
        data <<= 1;
    }

    /* acknowledge read */
    i2c_SDA_1();
    lcd_wait( 1 );

    /* SCL ON */
    i2c_SCL_1();
    lcd_wait( 1 );

    i2c_write_ret = i2c_sda;

    /* SCL OFF  */
    i2c_SCL_0();
#endif
}

/************************************************************************/
/* W[ i2c_ack_check                                           */
/* Tv     I2C ݌acknowledge`FbN                     */
/*          signed char f[^                                      */
/* ߂l       int  acknowledge 0:L  1: ACK_ERROR:̑̃G[*/
/************************************************************************/
static int i2c_ack_check( void )
{
#if I2C_SFR
    if( tdre_icsr == 0 ) return ACK_ERROR;
    if( tend_icsr == 0 ) return ACK_ERROR;

    return ackbr_icier;
#else
    return i2c_write_ret;
#endif
}

/************************************************************************/
/* W[ i2c_read                                                */
/* Tv     I2C PoCgǂݍ                                    */
/*          int ACKFf[^ ACK_NOFf[^I                */
/* ߂l       signed char f[^                                      */
/************************************************************************/
static signed char i2c_read( int ack )
{
#if I2C_SFR
    signed char ret;
    volatile int i;

    tend_icsr = 0;
    iccr1 &= 0xef;
    tdre_icsr = 0;
    ackbt_icier = 1;
    ret = icdrr;                        /* _~[[h                 */

    if( ack == ACK_NO ) {
        rcvd_iccr1 = 1;                 /* ̎M֎~           */
    }

    i = 1000;
    while( rdrf_icsr == 0 ) {
        if( !(i--) ) return 0;
    }

    iccr2 = 0x10;

    i = 1000;
    while( stop_icsr == 0 ) {
        if( !(i--) ) return 0;
    }

    ret = icdrr;
    rcvd_iccr1 = 0;
    ackbt_icier = 0;

    return ret;
#else
    char    ret;
    int     i;

    i2c_SDA_1();

    for( i = 0; i<8; i++ ) {
        ret <<= 1;

        /* SCL ON */
        i2c_SCL_1();
        lcd_wait( 1 );

        /* data read */
        if( i2c_sda ) {
            ret |= 0x01;
        }

        /* SCL OFF  */
        i2c_SCL_0();
    }

    /* acknowledge write */
    if( ack == ACK ) {
        i2c_SDA_0();
    } else {
        i2c_SDA_1();
    }

    /* SCL ON */
    i2c_SCL_1();
    lcd_wait( 1 );

    /* SCL OFF  */
    i2c_SCL_0();

    return ret;
#endif
}

/************************************************************************/
/* W[ lcdTimer                                                */
/* Tv     荞݂ɂ鐳mȃ^C}                              */
/*          ^C}l 1=1ms                                          */
/* ߂l                                                           */
/*          ݒ̃^C~O1mš덷܂               */
/************************************************************************/
static void lcdTimer( unsigned long timer_set )
{
    volatile unsigned long t;

    t = lcdCnt;

    while( lcdCnt - t < timer_set );
}

/************************************************************************/
/* W[ lcdOut                                                  */
/* Tv     I2CtR}ho                                     */
/*          R}hށAf[^                                    */
/* ߂l       0:ُ 1:                                           */
/************************************************************************/
static int lcdOut( char command, char data )
{
    int retry, ret, mode = 0;
    int error = 10;                     // G[`FbN

    while( 1 ) {

    switch( mode ) {
    case 0:
        //  X^[gs
        retry = 100;
        while( 1 ) {
            ret = i2c_start();
            if( ret == 0 ) {
                // G[Ȃ烊gC
                if( !(retry--) ) {
                    mode =  91;
                    break;
                }
            } else {
                // Ȃ玟
                mode = 1;
                break;
            }
        }
        break;

    case 1:
        // X[uAhX]
        retry = 100;
        i2c_write( 0x7c | !!(command&0x40) );
        while( 1 ) {
            if( i2c_ack_check() != ACK ) {
                // G[Ȃ烊gC
                if( !(retry--) ) {
                    mode =  91;
                    break;
                }
            } else {
                // Ȃ玟
                mode = 2;
                break;
            }
        }
        break;

    case 2:
        // Rg[oCg]
        retry = 100;
        i2c_write( (command & 0x80) >> 1 );
        while( 1 ) {
            if( i2c_ack_check() != ACK ) {
                // G[Ȃ烊gC
                if( !(retry--) ) {
                    mode =  91;
                    break;
                }
            } else {
                // Ȃ玟
                mode = 3;
                break;
            }
        }
        break;

    case 3:
        // f[^]
        retry = 100;
        i2c_write( data );
        while( 1 ) {
            if( i2c_ack_check() != ACK ) {
                // G[Ȃ烊gC
                if( !(retry--) ) {
                    mode =  91;
                    break;
                }
            } else {
                // Ȃ玟
                mode = 4;
                break;
            }
        }
        break;

    case 4:
        // Xgbvs
        ret = i2c_stop( STOP_WR );
        if( ret == 0 ) {
            mode = 91;
            break;
        } else {
            return 1;           // ɏI
        }
        break;

    case 91:
        // G[
        error--;
        if( !error ) return 0;  // G[I

        // Xgbvs
        lcd_wait( 100 );
        i2c_stop( STOP_WR );
        lcd_wait( 100 );

        // X^[gsɖ߂
        mode = 0;
        break;
    }

    }
    return 0;   // G[I
}

/************************************************************************/
/* W[ initLcd                                                 */
/* Tv     ST7032iRg[t̏                         */
/*          Ȃ                                                    */
/* ߂l       0:ُ 1:                                           */
/************************************************************************/
int initLcd( void )
{
    int i, ret;

    // ϐ
    for( i=0; i<=LCD_MAX_X*LCD_MAX_Y-1; i++ ) {
        buffLcdData[ i ] = ' ';
    }
    lcdCtrt2 = lcdCtrt;

#if I2C_SFR
    // |[g̓o͐ݒ
    pd3 &= 0x5f;                        /* P3_7:SDA P3_5:SCL            */

    // I2C̐ݒ
    iicsel = 1;
    stop_icsr = 0;
    ice_iccr1 = 1;
    icmr  = 0x00;
    iccr1 = 0x8d;                       /* CKS=f1/200 = 100KHz          */
    icier = 0x00;
    icsr  = 0x00;
    sar   = 0x00;
#else
    i2c_sdaddr = 0;
    i2c_sclddr = 0;
#endif

    lcdTimer( 40 );                     /* 40msȏ̃^C}             */

    // t̏ݒ
    ret = lcdOut( LCD_INST, 0x38 );     /* Function set                 */
    if( !ret ) return 0;
    lcd_wait( 100 );                    /* 26.3usȏ̃^C}           */

    ret = lcdOut( LCD_INST, 0x39 );     /* Function set                 */
    if( !ret ) return 0;
    lcd_wait( 100 );                    /* 26.3usȏ̃^C}           */

    ret = lcdOut( LCD_INST, 0x10 );     /* Internal OSC frequency       */
    if( !ret ) return 0;
    lcd_wait( 100 );                    /* 26.3usȏ̃^C}           */

    ret = lcdOut( LCD_INST, 0x70 |      /* Constrast set                */
        (lcdCtrt & 0x0f) );
    if( !ret ) return 0;
    lcd_wait( 100 );                    /* 26.3usȏ̃^C}           */

    ret = lcdOut( LCD_INST, 0x5c |      /* Power/ICON/Constrast control */
        (lcdCtrt & 0x30)>>4 );
    if( !ret ) return 0;
    lcd_wait( 100 );                    /* 26.3usȏ̃^C}           */

    ret = lcdOut( LCD_INST, 0x6a );     /* Follower control             */
    if( !ret ) return 0;
    lcdTimer( 205 );                    /* 200msȏ̃^C}            */

    ret = lcdOut( LCD_INST, 0x0c );     /* Display ON/OFF               */
    if( !ret ) return 0;
    lcd_wait( 100 );                    /* 26.3usȏ̃^C}           */

    ret = lcdOut( LCD_INST, 0x01 );     /* Display ON/OFF               */
    if( !ret ) return 0;
    lcd_wait( 100 );                    /* 26.3usȏ̃^C}           */

    ret = lcdOut( LCD_INST, 0x06 );     /* Display ON/OFF               */
    if( !ret ) return 0;
    lcd_wait( 100 );                    /* 26.3usȏ̃^C}           */

    lcdMode = 1;                        /* tڑ                 */

    return 1;
}

/************************************************************************/
/* W[ endLcd                                                  */
/* Tv     I2CtI                                         */
/*          Ȃ                                                    */
/* ߂l       Ȃ                                                    */
/************************************************************************/
void endLcd( void )
{
	int i = 0;
	
	while( lcdMode > 1 ) {				// Ȃ҂
		i++;
		if( i >= 32000 ) break;			// ҂тꂽ狭I
	} 
	lcdMode = 0;	// ڑ
}

/************************************************************************/
/* W[ lcdShowProcess                                          */
/* Tv     I2Ct\                                         */
/*          Ȃ                                                    */
/* ߂l       Ȃ                                                    */
/*          ̊֐͊荞݂1msƂɎsĂ           */
/************************************************************************/
void lcdShowProcess( void )
{
    static int lcdNowLocate;            /* ݂̕\Ăʒu       */
    static int lcdMode2;                /* \̖߂               */
    static signed char cmd, data;
    int ret, i;

    lcdCnt++;

    switch( lcdMode ) {
    case 0:
        // tڑ͉Ȃ
        break;

    case 1:
        // f[^XVꂽ`FbN
        if( lcdRefreshFlag ) {
            lcdRefreshFlag = 0;
            lcdNowLocate = 0;
            lcdMode = 11;
            break;
        }
        lcdMode = 2;
        break;

    case 2:
        // RgXg@ύXꂽH
        if( lcdCtrt2 != lcdCtrt ) {
            lcdCtrt2 = lcdCtrt;
            lcdMode = 3;
            break;
        }
        lcdMode = 1;
        break;

    case 3:
        // RgXgݒ1
        cmd  = LCD_INST;
        data = 0x70 | (lcdCtrt2 & 0x0f);
        lcdMode2 = 4;
        lcdMode = 21;
        break;

    case 4:
        // RgXgݒ2
        cmd  = LCD_INST;
        data = 0x5c | ( (lcdCtrt2 & 0x30) >> 4 );
        lcdMode2 = 1;
        lcdMode = 21;
        break;

    case 11:
        // sʒůmF
        if( lcdNowLocate % LCD_MAX_X == 0 ) {
            i = lcdNowLocate / LCD_MAX_X;
            if( i == 1 ) {
                i = 0x40;
            } else if( i == 2 ) {
                i = 0x14;
            } else if( i == 3 ) {
                i = 0x54;
            }
            cmd  = LCD_INST;
            data = i | 0x80;
            lcdMode2 = 12;
            lcdMode = 21;
        } else {
            lcdMode = 12;
        }
        break;

    case 12:
        // f[^\
        cmd  = LCD_DATA;
        data = buffLcdData[ lcdNowLocate++ ];
        lcdMode2 = 13;
        lcdMode = 21;
        break;

    case 13:
        // s`FbN
        if( lcdNowLocate >= LCD_MAX_X * LCD_MAX_Y ) {
            lcdMode = 2;
        } else {
            lcdMode = 11;
        }
        break;

    /* 20ԑ@I2Ct */
    case 21:
        // X^[gs
        ret = i2c_start();
        if( ret != 0 ) {
            // X[uAhX]
            i2c_write( 0x7c | !!(cmd&0x40) );
            lcdMode++;
        } else {
            lcdMode = 0;
        }
        break;

    case 22:
        // ACK`FbNARg[oCg]
        if( i2c_ack_check() == ACK ) {
            //  Rg[oCg]
            i2c_write( (cmd & 0x80) >> 1 );
            lcdMode++;
        } else {
            lcdMode = 0;
        }
        break;

    case 23:
        // ACK`FbNAf[^]
        if( i2c_ack_check() == ACK ) {
            // f[^]
            i2c_write( data );
            lcdMode++;
        } else {
            lcdMode = 0;
        }
        break;

    case 24:
        // ACK`FbNAXgbvs
        if( i2c_ack_check() == ACK ) {
            // Xgbvs
            ret = i2c_stop( STOP_WR );
            if( ret == 0 ) {
                lcdMode = 0;
                break;
            }
            lcdMode = lcdMode2;
        } else {
            lcdMode = 0;
        }
        break;

    }
}

/************************************************************************/
/* W[ lcdPrintf                                               */
/* Tv     I2Ct֕\@\ʒu͉ߋɕ\ʒu̎     */
/*          printfƓ                                            */
/* ߂l       펞Fo͂@ُ펞F̐                  */
/************************************************************************/
int lcdPrintf( char *format, ... )
{
    volatile va_list argptr;
    volatile char    *p;
    volatile int     ret = 0;
    volatile char    work[ LCD_MAX_X * LCD_MAX_Y + 16 ];
                                        /* \obt@ꎞƃGA   */

    va_start(argptr, format);
    ret = vsprintf( work, format, argptr );
    va_end(argptr);

    if( ret > 0 ) {
        /* vsprintfȂtobt@֓] */
        p = work;
        while( *p ) {
            buffLcdData[lcdBuffPosition++] = *p++;
            if( lcdBuffPosition >= LCD_MAX_X * LCD_MAX_Y ) {
                lcdBuffPosition = 0;
            }
        }
        lcdRefreshFlag = 1;
    }
    return ret;
}

/************************************************************************/
/* W[ lcdPosition                                             */
/* Tv     I2Ct̕\ʒuw                                   */
/*          ʒu , cʒu                                         */
/* ߂l       Ȃ                                                    */
/************************************************************************/
void lcdPosition( char x, char y )
{
    if( x >= LCD_MAX_X ) return;
    if( y >= LCD_MAX_Y ) return;

    lcdBuffPosition = x + y * LCD_MAX_X;
}

/************************************************************************/
/* W[ lcdContrast                                             */
/* Tv     I2Ct̃RgXgݒ                             */
/*          int RgXg                                        */
/* ߂l       Ȃ                                                    */
/************************************************************************/
void lcdContrast( int i )
{
    if( i >= 63 ) i = 63;
    if( i <=  0 ) i =  0;

    lcdCtrt = i;
}

/************************************************************************/
/* end of file                                                          */
/************************************************************************/

/*
o

2013.02.28 Ver.1.00 쐬
2013.03.11 Ver.1.10 쐬
2017.02.17 Ver.1.20 쐬 I2C EEP-ROMƌpł悤ɂ
*/
