/****************************************************************************/
/* Ώۃ}CR R8C/38A                                                     */
/* ̧ٓe     microSD 䃉Cu                                      */
/* o[W   Ver.3.11                                                    */
/* Date         2014.06.01                                                  */
/* Copyright    Wp}CRJ[[sψ                        */
/****************************************************************************/
/*

FAT32gȂꍇ
microSDƂĂ̂ݎgpAFAT32gȂꍇ́AFAT32̃vO
OFFɂ邱Ƃł܂B
OFFɂꍇ́AL̃p[^c[`FC̃RpCIvV
ǉĂB
-DNO_FAT32

*/

/*======================================*/
/* CN[h                         */
/*======================================*/
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>                     /* WCײ ό̎ */
#include "sfr_r838a.h"                  /* R8C/38A SFR̒`t@C    */
#include "microsd_lib.h"                /* microSD䃉Cu        */

/*======================================*/
/* 萔ݒ                             */
/*======================================*/
#define MSD_CS_BIT      p6_1            /* CS[q̃rbg               */
#define MSD_CS_BIT_DIM  pd6_1           /* CS[q̃rbg̓o͐ݒ   */
#define LED_BLINK       0x40            /* LED@ANZX̓_Ŏ    */
#define LED_ERRORBLINK  0x200           /* LED@G[̓_Ŏ      */

/*======================================*/
/* O[oϐ̐錾                 */
/*======================================*/
static unsigned char            msdlibBuff[512 + 128];
                                        /* ꎞۊǃobt@             */
static unsigned char            msdlibBuff2[512 + 128];
                                        /* ꎞۊǃobt@Q           */
static volatile int             msdlibMode;
                                        /*                          */
static volatile int             msdlibCnt;
                                        /* ݐ                   */
static volatile unsigned char*  msdlibRead;
                                        /* ǂݍ݃f[^̃AhX     */
static volatile unsigned char*  msdlibWrite;
                                        /* ݃f[^̃AhX     */
static volatile int             msdlibError;
                                        /* G[ԍ                   */
static volatile char*           led_port;
                                        /* j^LED̂|[g        */
static volatile char*           led_port_dim;
                                        /* L̓o͐ݒ|[g       */
static volatile char            led_port_bit;
                                        /* j^LED̂|[g̃rbg*/
static volatile unsigned int    msdLed;
                                        /* microSD j^pLED          */
                                        /* 0:gp 0ȊO:gp        */
static volatile int             msdType;
                                        /* microSD̃^Cv              */
                                        /* 1:MMC or SDJ[hVer.1.x     */
                                        /* 2:SDJ[hVer.2.0            */
                                        /* 3:SDHCJ[h                 */
static volatile unsigned long   msdSize;
                                        /* microSD̃TCY(kBP)      */
static volatile int             modeSector;
                                        /* 1:ZN^w胂[h 0:AhX*/
/////// FAT32֌Wϐ  /////////
#ifndef NO_FAT32
static volatile int             fFileOpen;
                                        /* ݍƒ1            */
static volatile unsigned long   BPB_SctorNo;
                                        /* BPB̃ZN^No                */
static volatile unsigned long   BPB_SectorsPerFAT;
                                        /* FAT̃ZN^                */
static volatile unsigned int    BPB_SctorsPerCluster;
                                        /* 1NX^̃ZN^          */
static volatile int             BPB_NumberOfFATs;
                                        /* FAT̐ ʏ2              */
static volatile int             BPB_ReservedSectors;
                                        /* BPB̗̈̃ZN^          */
static volatile unsigned long   BPB_bigTotalSectors;
                                        /* ZN^                   */
static volatile unsigned long   BPB_RootDirCluster;
                                        /* ٰިڸ؂NX^ԍ */
static volatile unsigned long   Sec_FAT[4];
                                        /* FAT̐擪AhX            */
static volatile unsigned long   Sec_Data;
                                        /* f[^̈̐擪AhX     */
static volatile unsigned long   Sec_Dir;
                                        /* fBNg̐擪AhX   */
static volatile unsigned long   writeSectorStart;
                                        /* ݊JnZN^           */
static volatile unsigned long   writeSectorEnd;
                                        /* ݏIZN^           */
static volatile unsigned long   writeSectorWork;
                                        /* ݒ̃ZN^           */

static const char monthStr[] = { "JanFebMarAprMayJunJulAugSepOctNovDec" };
                                        /* ϊe[u               */
static volatile unsigned char   fileYear  = 2012-1980;  /* ݁@N */
static volatile unsigned char   fileMonth = 4;          /* ݁@ */
static volatile unsigned char   fileDay   = 1;          /* ݁@ */
static volatile unsigned char   fileHour  = 12;         /* ݁@ */
static volatile unsigned char   fileMin   = 0;          /* ݁@ */
static volatile unsigned char   fileSec   = 0 / 2;      /* ݁@b */

static volatile char            msdPrintfBuff_Format[128];
                                        /* msdPrintf̏              */
static volatile char            msdPrintfBuff_Para[64];
                                        /* msdPrintf̈              */
static volatile char            *pFormat;
                                        /* msdPrintf̏̃|C^    */
static volatile char            *pPara;
                                        /* msdPrintf̈̃|C^    */
static volatile char            *pWriteBuff = msdlibBuff;
                                        /* microSDޯ̧߲  */
static volatile int             writeBuffNo;
                                        /* 0:msdlibBuff ɏ      */
                                        /* 1:msdlibBuff2ɏ      */
static volatile int             msdPrintfMode;
                                        /*microSDPrintfProcess֐̏*/
#endif
/////// FAT32֌Wϐ ܂ /////////

/************************************************************************/
/* W[ msd_write                                               */
/* Tv     microSD@PoCg                               */
/*          char f[^                                             */
/* ߂l       Ȃ                                                    */
/************************************************************************/
static void msd_write( unsigned char data )
{
    volatile unsigned int i;

    u1tbl = data;
    while( ri_u1c1 == 0 );              /* Mf[^ȂȂJԂ   */
    i = u1rb;                           /* _~[[h                 */
}

/************************************************************************/
/* W[ msd_read                                                */
/* Tv     microSD@PoCgǂݍ                               */
/*          Ȃ                                                    */
/* ߂l       char f[^                                             */
/************************************************************************/
static unsigned char msd_read( void )
{
    volatile unsigned char  ret;
    volatile unsigned int   data;

    u1tbl = 0xff;                       /* _~[Cg                 */
    while( ri_u1c1 == 0 );              /* Mf[^ȂȂJԂ   */

    data = u1rb;
    ret = data & 0x00ff;

    return ret;
}

/************************************************************************/
/* W[ sendCMD                                                 */
/* Tv     R}hM                                            */
/*          R}hA1,2,3,4,CRC                   */
/* ߂l       microSD̖߂l                                     */
/************************************************************************/
static unsigned char sendCMD(
    unsigned char cmd,  unsigned char arg1, unsigned char arg2,
    unsigned char arg3, unsigned char arg4, unsigned char crc   )
{
    volatile int            i;
    volatile unsigned char  ret;

    msd_write( 0xff );

    msd_write( cmd );
    msd_write( arg1 );
    msd_write( arg2 );
    msd_write( arg3 );
    msd_write( arg4 );
    msd_write( crc );

    /* X|XM */
    i = 1500;                           /* gC Ver3.11 5001500 */
    while( --i ) {
        MSD_CS_BIT = 1;

        MSD_CS_BIT = 0;

        ret = msd_read();
        if( ret != 0xff ) break;        /* 0xffȊOŏI               */
    }
    return ret;
}

/************************************************************************/
/* W[ initMicroSD                                             */
/* Tv     microSDJ[h̏                                   */
/*          Ȃ                                                    */
/* ߂l       0: 1ȏ:G[                                     */
/************************************************************************/
int initMicroSD( void )
{
    volatile int i, r, ret = 0;
    unsigned char rr[16];

    msdlibMode = 1;

    MSD_CS_BIT_DIM = 1;                 /* CS_BIT͏o͒[qɐݒ       */

    /* UART1̐ݒ */
    pd6_4 = 0;                          /* P6_4/RXD1͓͒[qɐݒ    */
    u1sr  = 0x2a;                       /* UART1̒[qI              */
    s1tic = 0x00;                       /* UART1M荞݋֎~        */
    s1ric = 0x00;                       /* UART1M荞݋֎~        */
    u1mr  = 0x01;                       /* ۯرI/OӰނɐݒ  */
    u1c0  = 0x80;                       /* MSBt@[XgAf1I      */
    u1c1  = 0x00;                       /* M荞ݗvI         */
    u1brg = 200-1;                      /* rbg[g 20MHz * 1/f1 *  */
                                        /*       1/200 * 1/2 = 50000bps */
    te_u1c1 = 1;                        /* MrbgFM     */
    re_u1c1 = 1;                        /* MrbgFM     */

    /* e[qݒ */
    MSD_CS_BIT = 1;

    for( i=0; i<10; i++ );

    /* 10oCg_~[őȂA͒[q`FbN */
    for( i=0; i<10; i++ ) {
        r = msd_read();
        if( r != 0xff ) {               /* ڑH                     */
            ret = 1;
            goto initMicroSD_End;
        }
    }

    MSD_CS_BIT = 0;

    /* CMD0M */
    i = 0;
    do {
        /* LED_ŏ */
        if( msdLed == 0x4000 ) msdLed += LED_BLINK;

        r = sendCMD( 0x40, 0x00, 0x00, 0x00, 0x00, 0x95 );
        i++;
        if( i >= 10 ) {
            ret = 2;
            goto initMicroSD_End;
        }
    } while( (r&0xfe) != 0x00 );

    /* CMD8M */
    msdType = 0;
    i = 0;
    do {
        /* LED_ŏ */
        if( msdLed == 0x4000 ) msdLed += LED_BLINK;

        r = sendCMD( 0x48, 0x00, 0x00, 0x01, 0xaa, 0x87 );
        i++;
        if( i >= 20 ) {
            msdType = MSD_TYPE_SD100;
            break;
        }
    } while( r == 0xff );

    if( msdType != MSD_TYPE_SD100 ) {
        /* R7R}hǂݍ */
        for( i=0; i<5; i++ ) {
            rr[i] = msd_read();
        }
        if( (rr[2] != 0x01) || (rr[3] != 0xaa) ) {
            ret = 3;
            goto initMicroSD_End;
        }
    }

    if( msdType == MSD_TYPE_SD100 ) {
        // MMCJ[h Ver.2ȑÕJ[h

        /* CMD1M */
        i = 0;
        do {
            /* LED_ŏ */
            if( msdLed == 0x4000 ) msdLed += LED_BLINK;

            MSD_CS_BIT = 1;
            msd_write( 0xff );
            MSD_CS_BIT = 0;

            r = sendCMD( 0x41, 0x00, 0x00, 0x00, 0x00, 0xf9 );
            i++;
            if( i >= 500 ) {
                ret = 4;
                goto initMicroSD_End;
            }
        } while( r != 0x00 );

        /* CMD16M */
        i = 0;
        do {
            r = sendCMD( 0x50, 0x00, 0x00, 0x02, 0x00, 0x00 );
            i++;
            if( i >= 10 ) {
                ret = 5;
                goto initMicroSD_End;
            }
        } while( r != 0x00 );
    } else {
        // Ver.2.00ȍ~SDJ[h

        // CMD58
        i = 0;
        do {
            /* LED_ŏ */
            if( msdLed == 0x4000 ) msdLed += LED_BLINK;

            r = sendCMD( 0x7a, 0x40, 0x00, 0x00, 0x00, 0xaf );
            i++;
            if( i >= 50 ) {
                ret = 6;
                goto initMicroSD_End;
            }
        } while( r != 0x01 );
        // cM
        for( i=0; i<6; i++ ) {
            rr[i] = msd_read();
        }

        // ACMD41
        i = 0;
        do {
            /* LED_ŏ */
            if( msdLed == 0x4000 ) msdLed += LED_BLINK;

            // CMD55
            r = sendCMD( 0x77, 0x00, 0x00, 0x00, 0x00, 0x65 );
            // ACMD41
            r = sendCMD( 0x69, 0x40, 0x00, 0x00, 0x00, 0x77 );
            i++;
            if( i >= 1000 ) {
                ret = 7;
                goto initMicroSD_End;
            }
        } while( r != 0x00 );

        // CMD58
        i = 0;
        do {
            /* LED_ŏ */
            if( msdLed == 0x4000 ) msdLed += LED_BLINK;

            r = sendCMD( 0x7a, 0x40, 0x00, 0x00, 0x00, 0xaf );
            i++;
            if( i >= 10 ) {
                ret = 8;
                goto initMicroSD_End;
            }
        } while( r != 0x00 );
        // cM
        for( i=0; i<6; i++ ) {
            rr[i] = msd_read();
        }
        if( rr[0] & 0x40 ) msdType = MSD_TYPE_SDHC;
        else msdType = MSD_TYPE_SD200;
    }

    /* eʂ̌vZ */
    r = getMicroSD_CSD( rr );
    if( r != 0x00 ) {
        ret = 9;
        goto initMicroSD_End;
    }

    if( msdType != MSD_TYPE_SDHC ) {
        // SDHCȊO
        msdSize   = ((unsigned int)rr[ 6]&0x03) << 10;
        msdSize  |=  (unsigned int)rr[ 7]       <<  2;
        msdSize  |= ((unsigned int)rr[ 8]&0xc0) >>  6;
        msdSize  += 1;
        i         = ((unsigned int)rr[ 9]&0x03) <<  1;
        i        |= ((unsigned int)rr[10]&0x80) >>  7;
        i        += 2;
        msdSize <<= i;
        i         = (unsigned int)rr[5] & 0x0f;
        msdSize <<= i;
        msdSize >>= 10;                 /* P kB                      */
    } else {
        // SDHC̏ꍇ
        msdSize   = ((unsigned int)rr[7]&0x3f) << 16;
        msdSize  |=  (unsigned int)rr[8] << 8;
        msdSize  |=  (unsigned int)rr[9];
        msdSize  += 1;
        msdSize <<= 9;                  /* P kB                      */
    }

initMicroSD_End:
    MSD_CS_BIT = 1;

    if( ret == 0 ) {
        // @
        te_u1c1 = 0;                    /* MrbgFM֎~     */
        re_u1c1 = 0;                    /* MrbgFM֎~     */
        u1brg   = 80-1;                 /* rbg[g 20MHz * 1/80 *  */
                                        /*              1/2 = 125000bps */
        te_u1c1 = 1;                    /* MrbgFM     */
        re_u1c1 = 1;                    /* MrbgFM     */

        msdlibMode = 0;
    } else {
        // @G[
        msdlibMode = 99;
        if( msdLed ) msdLed = 0x8000;
    }
    return ret;
}

/************************************************************************/
/* W[ getMsdType                                              */
/* Tv     microSD̃^Cv擾                                   */
/*                                                              */
/* ߂l       MSD_TYPE_SD100AMSD_TYPE_SD200AMSD_TYPE_SDHC           */
/************************************************************************/
int getMsdType( void )
{
    return msdType;
}

/************************************************************************/
/* W[ getMsdSize                                              */
/* Tv     microSD̃TCY擾                                   */
/*                                                              */
/* ߂l       TCYikBP)                                         */
/************************************************************************/
unsigned long getMsdSize( void )
{
    return msdSize;
}

/************************************************************************/
/* W[ readMicroSD                                             */
/* Tv     microSDf[^ǂݍ(512oCg)                    */
/*          unsigned long   AhX                                */
/*              signed char     *ǂݍޔz̃AhX                 */
/* ߂l       0: 1ȏ:G[                                     */
/************************************************************************/
int readMicroSD( unsigned long address, signed char *read )
{
    volatile int            i, r, ret = 0;
    volatile unsigned char  a1, a2, a3, a4;

    if( msdlibMode != 0 ) {             /* ʂȍƒȂG[         */
        return 1;
    }
    msdlibMode = 1;

    /* LED_ŏ */
    if( msdLed == 0x4000 ) msdLed += LED_BLINK;

    if( modeSector == 1 ) {
        // ZN^w
        if( msdType != MSD_TYPE_SDHC ) {
            // SDHCłȂAhXZN^ԍɕϊ
            address <<= 9;
        }
    } else {
        // AhXw
        if( msdType == MSD_TYPE_SDHC ) {
            // SDHCȂAhXZN^ԍɕϊ
            address >>= 9;
        }
    }

    a1 = (unsigned char)( (address&0xff000000) >> 24);
    a2 = (unsigned char)( (address&0x00ff0000) >> 16);
    a3 = (unsigned char)( (address&0x0000ff00) >>  8);
    a4 = (unsigned char)(  address&0x000000ff       );

    MSD_CS_BIT = 1;

    /* _~[NbNM */
    msd_write( 0xff );

    MSD_CS_BIT = 0;

    /* _~[NbNM */
    msd_write( 0xff );

    /* CMD17M */
    r = sendCMD( 0x51, a1, a2, a3, a4, 0xff );

    /* X|XmF */
    if( r != 0x00 ) {
        ret = 11;
        goto readMicroSD_End;
    }

    /* 0xfemF */
    i = 0;
    do {
        r = msd_read();
        i++;
        if( i >= 1000 ) {
            ret = 12;
            goto readMicroSD_End;
        }
    } while( r != 0xfe );

    /* f[^ǂݍ */
    for( i=0; i<512; i++ ) {
        *read++ = msd_read();
    }

    /* CRC 2oCgǂݍ */
    msd_read();
    msd_read();

readMicroSD_End:
    /* _~[NbNM */
    msd_write( 0xff );
    MSD_CS_BIT = 1;
    msdlibMode = (ret != 0) ? 99 : 0;   /* G[Ȃ99Zbg   */

    return ret;
}

/************************************************************************/
/* W[ writeMicroSD                                            */
/* Tv     microSD(512oCg)                              */
/*          unsigned long   AhX                                */
/*              signed char     *ޔz̃AhX                 */
/* ߂l       0: 1ȏ:G[                                     */
/************************************************************************/
int writeMicroSD( unsigned long address, signed char *write )
{
    volatile int            i, r, ret = 0;
    volatile unsigned char  a1, a2, a3, a4;

    if( msdlibMode != 0 ) {             /* ʂȍƒȂG[         */
        return 1;
    }
    msdlibMode = 1;

    /* LED_ŏ */
    if( msdLed == 0x4000 ) msdLed += LED_BLINK;

    if( modeSector == 1 ) {
        // ZN^w
        if( msdType != MSD_TYPE_SDHC ) {
            // SDHCłȂAhXZN^ԍɕϊ
            address <<= 9;
        }
    } else {
        // AhXw
        if( msdType == MSD_TYPE_SDHC ) {
            // SDHCȂAhXZN^ԍɕϊ
            address >>= 9;
        }
    }

    MSD_CS_BIT = 0;

    /* CMD24M */
    a1 = (unsigned char)( (address&0xff000000) >> 24);
    a2 = (unsigned char)( (address&0x00ff0000) >> 16);
    a3 = (unsigned char)( (address&0x0000ff00) >>  8);
    a4 = (unsigned char)(  address&0x000000ff       );
    r = sendCMD( 0x58, a1, a2, a3, a4, 0x00 );

    /* X|XmF */
    if( (r&0x1f) != 0x00 ) {
        ret = 21;
        goto writeMicroSD_End;
    }

    /* 1oCgԂ󂯂 */
    r = msd_read();

    /* Jn} */
    msd_write( 0xfe );

    /* f[^M */
    for( i=0; i<512; i++ ) {
        msd_write( *write++ );
    }

    /* CRCM */
    msd_write( 0xff );
    msd_write( 0xff );

    /* X|Xǂݍ */
    r = msd_read();
    r &= 0x1f;

    if( r == 0x05 ) {
        ret = 0;        /* ݐI */
    } else if( r == 0x0d ) {
        ret = 22;       /* ݃G[   */
    } else {
        ret = 23;       /* ȊÕG[ */
    }

    /* busyԂI܂ő҂ */
    for( i=0; i<10000; i++ ) {
        if( msd_read() != 0x00 ) break;
    }

writeMicroSD_End:
    /* _~[NbNM */
    msd_write( 0xff );
    MSD_CS_BIT = 1;
    msdlibMode = (ret != 0) ? 99 : 0;   /* G[Ȃ99Zbg   */

    return ret;
}

/************************************************************************/
/* W[ getMicroSD_CSD                                          */
/* Tv     microSD Card Specific Data擾                          */
/*          signed char *ǂݍݔz(16oCgȏ)                 */
/* ߂l       0: 1ȏ:G[                                     */
/************************************************************************/
int getMicroSD_CSD( unsigned char *p )
{
    volatile int i, r, ret = 0;

    /* LED_ŏ */
    if( msdLed == 0x4000 ) msdLed += LED_BLINK;

    MSD_CS_BIT = 0;

    /* CMD9M */
    r = sendCMD( 0x49, 0x00, 0x00, 0x00, 0x00, 0xaf );

    /* X|XmF */
    i = 0;
    do {
        r = msd_read();
        i++;
        if( i >= 1000 ) {
            ret = 31;
            goto getMicroSD_CSD_End;
        }
    } while( r & 0x80 );

    *p++ = r;

    /* CSDǂݍ */
    for( i=1; i<16; i++ ) {
        *p++ = msd_read();
    }

    /* _~[[h */
    msd_read();
    msd_read();

getMicroSD_CSD_End:
    /* _~[NbNM */
    msd_write( 0xff );
    MSD_CS_BIT = 1;

    return ret;
}

/************************************************************************/
/* W[ eraseMicroSD                                            */
/* Tv     microSD̃f[^C[X(0x00)                   */
/*          unsinged long JnAhX , IAhX               */
/* ߂l       0: 1ȏ:G[                                     */
/************************************************************************/
int eraseMicroSD( unsigned long st_address, unsigned long ed_address )
{
    volatile int            i, j, r, ret = 0;
    volatile unsigned char  a1, a2, a3, a4;

    if( msdlibMode != 0 ) {             /* ʂȍƒȂG[         */
        return msdlibMode;
    }
    msdlibMode = 1;

    if( msdLed ) msdLed += LED_BLINK;

    if( modeSector == 1 ) {
        // ZN^w
        if( msdType != MSD_TYPE_SDHC ) {
            // SDHCłȂZN^AhXԍɕϊ
            st_address <<= 9;
            ed_address <<= 9;
            ed_address += 511;
        }
    } else {
        // AhXw
        if( msdType == MSD_TYPE_SDHC ) {
            // SDHCȂAhXZN^ԍɕϊ
            st_address >>= 9;
            ed_address >>= 9;
        }
    }

    MSD_CS_BIT = 0;

    /* CMD32M(C[XJnAhX̃Zbg) */
    a1 = (unsigned char)( (st_address&0xff000000) >> 24);
    a2 = (unsigned char)( (st_address&0x00ff0000) >> 16);
    a3 = (unsigned char)( (st_address&0x0000ff00) >>  8);
    a4 = (unsigned char)(  st_address&0x000000ff       );
    r = sendCMD( 0x60, a1, a2, a3, a4, 0xff );

    /* X|XmF */
    if( r != 0x00 ) {
        ret = 41;
        goto eraseMicroSD_End;
    }

    for( j=0; j<10000; j++ );           // Ver.3.11ǉ

    /* CMD33M(C[XIAhX̃Zbg) */
    a1 = (unsigned char)( (ed_address&0xff000000) >> 24);
    a2 = (unsigned char)( (ed_address&0x00ff0000) >> 16);
    a3 = (unsigned char)( (ed_address&0x0000ff00) >>  8);
    a4 = (unsigned char)(  ed_address&0x000000ff       );
    r = sendCMD( 0x61, a1, a2, a3, a4, 0xff );

    /* X|XmF */
    if( r != 0x00 ) {
        ret = 42;
        goto eraseMicroSD_End;
    }

    for( j=0; j<10000; j++ );           // Ver.3.11ǉ

    /* CMD38M(C[X) */
    r = sendCMD( 0x66, 0, 0, 0, 0, 0xff );

    /* X|XmF */
    if( r != 0x00 ) {
        ret = 43;
        goto eraseMicroSD_End;
    }

    /* busyԂI܂ő҂ */
    for( i=0; i<10000; i++ ) {
        if( msd_read() != 0x00 ) break;
    }

eraseMicroSD_End:
    /* _~[NbNM */
    for( j=0; j<10000; j++ );           // Ver.3.11ǉ
    msd_write( 0xff );
    MSD_CS_BIT = 1;

    /* C[XAP_~[Cg */
    if( ret == 0 ) {
        for( i=0; i<512; i++ ) msdlibBuff[i] = 0;   /* obt@NA   */

        msdlibMode = 0;
        r = writeMicroSD( st_address, (signed char*)msdlibBuff );
        if( r != 0x00 ) {
            /* ݂ł */
            // ܂ɃG[ԂmicroSD邪AȂ悤Ȃ̂
            // G[͖Ă
            //ret = 44;
        }
    }

    msdlibMode = (ret != 0) ? 99 : 0;   /* G[Ȃ99Zbg   */

    return ret;
}

/************************************************************************/
/* W[ setMicroSDdata                                          */
/* Tv     microSDɃf[^Zbg                                   */
/*          microSDɏރf[^̂z                       */
/* ߂l       12:ɏI ȊO:ݒō̃Zbg͖   */
/************************************************************************/
int setMicroSDdata( signed char *p )
{
    volatile int ret = 0;

    /* LED_ŏ */
    if( msdLed == 0x4000 ) msdLed += LED_BLINK;

#ifndef NO_FAT32
    /* ]̃G[Ȃ`FbN */
    if( msdlibMode == 0 ) {
        if( fFileOpen ) {
            if( msdLed ) msdLed = 0x8000;
            fFileOpen = 0;
            return 1;
        }
    }

    /* t@CƂďݎ̏̃`FbN */
    if( fFileOpen ) {
        if( writeSectorWork > writeSectorEnd ) {
            fFileOpen = 0;
            return 1;
        }
        writeSectorWork++;
    }
#endif

    if( msdlibMode != 11) {             /* ݏݏH       */
        goto setMicroSDdata_End;
    }

    /* 512oCg msdlibBuff֓] */
    msdlibRead = (unsigned char*)p;     /* ]Zbg                 */
    _asm( " mov.b _msdlibRead >> 16   ,r1h " );
    _asm( " mov.w _msdlibRead & 0ffffh, a0 " );
    _asm( " mov.w #_msdlibBuff        , a1 " );
    _asm( " mov.w #256                , r3 " );
    _asm( " smovf.w" );

    msdlibBuff[512] = 0xff;
    msdlibBuff[513] = 0xff;

    msdlibCnt = 514;                    /* obt@ݐ           */
    msdlibWrite = msdlibBuff;
    s1tic = 0x02;
    u1tbl = 0xfc;                       /* 1M(c݂͊)  */
    msdlibMode = 12;                    /* microSDProcess Jn      */

setMicroSDdata_End:
    return msdlibMode;
}

/************************************************************************/
/* W[ microSDProcessStart                                     */
/* Tv     microSDProcessJn                                  */
/*          microSD̏݃AhX                               */
/* ߂l       0:ɏI ȊO:ɏݒ                    */
/************************************************************************/
int microSDProcessStart( unsigned long address )
{
    volatile int            ret = 0, r;
    volatile unsigned char  a1, a2, a3, a4;

    if( msdlibMode != 0 ) {
        /* ɏ */
        ret = 1;
        goto microSDProcessStart_End;
    }

    if( msdLed ) msdLed += LED_BLINK;

    if( modeSector == 1 ) {
        // ZN^w
        if( msdType != MSD_TYPE_SDHC ) {
            // SDHCłȂAhXZN^ԍɕϊ
            address <<= 9;
        }
    } else {
        // AhXw
        if( msdType == MSD_TYPE_SDHC ) {
            // SDHCȂAhXZN^ԍɕϊ
            address >>= 9;
        }
    }

    /* microSDɏ݃AhXZbg */
    a1 = (unsigned char)( (address&0xff000000) >> 24);
    a2 = (unsigned char)( (address&0x00ff0000) >> 16);
    a3 = (unsigned char)( (address&0x0000ff00) >>  8);
    a4 = (unsigned char)(  address&0x000000ff       );

    MSD_CS_BIT = 0;

    /* CMD25M */
    r = sendCMD( 0x59, a1, a2, a3, a4, 0xff );

    /* X|XmF */
    if( (r&0x80) != 0x00 ) {
        ret = 2;                        /* Zbgł                 */
        MSD_CS_BIT = 1;
    } else {
        msdlibMode = 11;                /* Zbg                   */
    }

microSDProcessStart_End:
    return ret;
}

/************************************************************************/
/* W[ microSDProcessEnd                                       */
/* Tv     microSDProcessI                                  */
/*          microSD̏݃AhX                               */
/* ߂l       0:ɏI ȊO:ɏݒ                    */
/************************************************************************/
int microSDProcessEnd( void )
{
    volatile int ret = 1;

    if( msdlibMode == 11 ) {
        msdlibMode = 21;                /* IZbg               */
    } else if( msdlibMode == 0 ) {
        /* LED_ŏ */
        msdLed = 0;
        ret = 0;                        /* I                         */
    }

    return ret;
}

/************************************************************************/
/* W[ microSDProcess                                          */
/* Tv     microSD@Ԍݏ                               */
/*          Ȃ                                                    */
/* ߂l       Ȃ                                                    */
/*          1msƂɊ荞ݏsĂ             */
/************************************************************************/
void microSDProcess( void )
{
    volatile int i, r;

    /* microSD msdPrintf֐(1msƂɎs) */
    microSDPrintfProcess();

    /* j^LED */
    if( msdLed ) {
        if( msdLed & 0x8000 ) {
            /* G[Ȃ */
            msdLed |= LED_ERRORBLINK;
            msdLed--;
            if( msdLed & (LED_ERRORBLINK>>1) ) {
                *led_port |= led_port_bit;
            } else {
                *led_port &= ~led_port_bit;
            }
        } else if( msdLed & 0x4000 ) {
            /* _łȂ */
            if( msdLed & 0x3fff ) msdLed--;
            msdLed &= ( 0x4000 | ((LED_BLINK<<1)-1) );
            if( msdLed & (LED_BLINK>>1) ) {
                *led_port |= led_port_bit;
            } else {
                *led_port &= ~led_port_bit;
            }
        }
    }

    switch( msdlibMode ) {
    case 0:
        /* JnȎҋ@ */
        break;

    case 1:
        /* ʂȍƒ */
        break;

    case 11:
        /* Jn̑ҋ@@ */
        break;

    case 12:
        /* M荞݂microSDɃf[^ݒ */
        if( msdlibCnt == 0 ) {
            msdlibMode = 13;
        }
        break;

    case 13:
        /* Ō̃f[^܂ő҂ */
        if( ri_u1c1 == 1 ) {
            i = u1rb;                   /* _~[[h                 */
            msdlibMode = 14;
        }
        break;

    case 14:
        /* I */

        /* X|Xǂݍ */
        r = msd_read();
        r &= 0x1f;

        if( r == 0x05 ) {
            msdlibError = 2;            /* ݐI             */
            msdlibMode = 15;
        } else if( r == 0xc ) {
            msdlibError = 3;            /* ݃G[               */
            msdlibMode = 31;
        } else {
            msdlibError = 4;            /* ȊÕG[             */
            msdlibMode = 31;
        }
        break;

    case 15:
        /* busyԂI܂ő҂ */
        if( msd_read() != 0x00 ) {
            msdlibMode = 11;
        }
        break;

    case 21:
        /* I */
        msd_write( 0xfd );
        msdlibMode = 22;
        break;

    case 22:
        /* busyԂI܂ő҂ */
        if( msd_read() != 0x00 ) {
            msdlibMode = 31;
        }
        break;

    case 31:
        /* CS="1" */
        msd_write( 0xff );              /* _~[NbNM           */
        MSD_CS_BIT = 0;
        msdlibMode = 32;                /* I                     */
        msdlibCnt = 10;
        break;

    case 32:
        msdlibCnt--;
        if( msdlibCnt == 0 ) {
            msdlibMode = 0;             /* I                     */
        }
        break;

    case 99:
        /* G[ */
        break;
    }
}

/************************************************************************/
/* W[ checkMicroSDProcess                                     */
/* Tv     microSD@Ԍݏ̏I`FbN                 */
/*          Ȃ                                                    */
/* ߂l       0: 11:Jn̑ҋ@ ȊO:              */
/************************************************************************/
int checkMicroSDProcess( void )
{
  return msdlibMode;
}

/************************************************************************/
/* UART1M 荞ݏ                                               */
/************************************************************************/
#pragma interrupt intS1T(vect=19)
void intS1T( void )
{
    u1tbl = *msdlibWrite++;             /* f[^M                   */
    msdlibCnt--;

    if( ri_u1c1 == 1 ) u1rb;            /* _~[[h                 */

    if( msdlibCnt == 0 ) {              /* Mf[^Ȃ         */
        s1tic = 0x00;
    }
}

/************************************************************************/
/* W[ setMicroSDLedPort                                       */
/* Tv     microSD@j^LED̐ݒ                                */
/*          char* j^LED̂|[g                             */
/*              char* j^LED̂|[g̓o͐ݒ|[g           */
/*              int   j^LED̂|[g̃rbg                     */
/* ߂l       Ȃ                                                    */
/************************************************************************/
void setMicroSDLedPort( char *p, char *pd, int bit )
{
    led_port     = p;
    led_port_dim = pd;
    led_port_bit = 0x01 << bit;

    *led_port_dim |= led_port_bit;      /* LEDbito͂ɐݒ         */

    msdLed = 0x4000;                    /* LED_ ON               */
}

//////////////////////////////////////////////////////////////////////////
// FAT32֌WvO                                          //
//////////////////////////////////////////////////////////////////////////
#ifndef NO_FAT32

/************************************************************************/
/* W[ convertBinaryToLong                                     */
/* Tv     oCi[f[^4byteslong֕ϊ                      */
/* @       ϊ̃AhX                                        */
/* ߂l       ϊlong^̒l                                      */
/************************************************************************/
static unsigned long convertBinaryToLong( char *p )
{
    unsigned long data;

    data  = *(unsigned long*)(p+3) << 24;
    data |= *(unsigned long*)(p+2) << 16;
    data |= *(unsigned long*)(p+1) <<  8;
    data |= *(unsigned long*)(p+0);

    return  data;
}

/************************************************************************/
/* W[ mountMicroSD_FAT32                                      */
/* Tv     FAT32Ń}Eg(FAT16͖Ή)                          */
/* @                                                           */
/* ߂l       0:FAT32Ń}Eg 1:}Egł                  */
/************************************************************************/
int mountMicroSD_FAT32( void )
{
    int ret, i;

    modeSector = 1;                     // AhXIZN^

    // 0ԒnǂݍMBRBPBmF
    ret = readMicroSD( 0x0000 , (signed char*)msdlibBuff );
    if( ret != 0 ) {
        ret = 1;
        goto mountMicroSD_FAT32_Error;
    }

    // MBR ܂ BPBłȂȂG[
    if( msdlibBuff[510] != 0x55 || msdlibBuff[511] != 0xaa ) {
        ret = 2;
        goto mountMicroSD_FAT32_Error;
    }

    // MBRZN^ȂBPBZN^ԍǂݍ
    if( msdlibBuff[0] != 0xeb && msdlibBuff[0] != 0xe9 ) {
        BPB_SctorNo = convertBinaryToLong( msdlibBuff+454 );

        // BPBǂݍ
        readMicroSD( BPB_SctorNo , (signed char*)msdlibBuff );
        if( ret != 0 ) {
            ret = 3;
            goto mountMicroSD_FAT32_Error;
        }

        // BPBłȂȂG[
        if( msdlibBuff[510] != 0x55 || msdlibBuff[511] != 0xaa ) {
            ret = 4;
            goto mountMicroSD_FAT32_Error;
        }
        // BPBłȂȂG[
        if( msdlibBuff[0] != 0xeb && msdlibBuff[0] != 0xe9 ) {
            ret = 5;
            goto mountMicroSD_FAT32_Error;
        }
    }

    // FAT16BPBZN^ǂݍ
    if( msdlibBuff[22] != 0x00 || msdlibBuff[23] != 0x00 ) {
        // FAT12orFAT16͖Ή
        ret = 11;
        goto mountMicroSD_FAT32_Error;
    }

    // BPBɊւvZ
    BPB_SctorsPerCluster = (unsigned int)msdlibBuff[13];
    BPB_NumberOfFATs     = (unsigned int)msdlibBuff[16];

    BPB_ReservedSectors  = (unsigned int)msdlibBuff[15] << 8;
    BPB_ReservedSectors |= (unsigned int)msdlibBuff[14];

    BPB_bigTotalSectors  = convertBinaryToLong( msdlibBuff+32 );

    BPB_SectorsPerFAT    = convertBinaryToLong( msdlibBuff+36 );

    BPB_RootDirCluster   = convertBinaryToLong( msdlibBuff+44 );

    // FAT̃ZN^vZ
    for( i=0; i<BPB_NumberOfFATs; i++ ) {
        Sec_FAT[i] = BPB_SctorNo+BPB_ReservedSectors + BPB_SectorsPerFAT*i;
    }

    // f[^̃ZN^vZ
    Sec_Data = BPB_SctorNo +
            BPB_ReservedSectors + BPB_SectorsPerFAT * BPB_NumberOfFATs;

    // fBNgZN^vZ
    Sec_Dir  = (BPB_RootDirCluster-2) * BPB_SctorsPerCluster;
    Sec_Dir += Sec_Data;

    modeSector = 0;                     // AhXIAhX

    return 0;

mountMicroSD_FAT32_Error:
    modeSector = 0;                     // AhXIAhX
    if( msdLed ) msdLed = 0x8000;

    return ret;
}

/************************************************************************/
/* W[ ClusterToSector                                         */
/* Tv     NX^ZN^vZ                                */
/* @       unsigned long NX^                                  */
/* ߂l       ZN^ԍ                                              */
/************************************************************************/
static unsigned long ClusterToSector( unsigned long cluster )
{
    unsigned long work;

    work  = (cluster-2) * BPB_SctorsPerCluster;
    work += Sec_Data;

    return work;
}

/************************************************************************/
/* W[ nextCluster                                             */
/* Tv     ̃NX^                                        */
/* @       unsigned long ݂̃NX^                            */
/*              unsigned long ݂̃NX^Ō̂ƂA̒lȏ  */
/*                            NX^ԍŐVNX^        */
/*                            1ȉȂ炸ɁAI               */
/* ߂l       ̃NX^ԍ                                        */
/*              0ȂeʃI[o[ōꂸA܂̓G[                 */
/************************************************************************/
static unsigned long nextCluster(
                            unsigned long cluster, unsigned long s_cls )
{
    int i, ret;
    unsigned long   i4, s_cls2 = 0xffffffff;

    // NX^̏`FbN
    if( ClusterToSector(cluster)+7 >= BPB_bigTotalSectors ) {
        return 0;
    }

    ret = readMicroSD(
                Sec_FAT[0] + (cluster>>7), (signed char*)msdlibBuff );
    if( ret != 0 ) {
        return 0;
    }

    i = (cluster & 0x0000007f) << 2;
    i4  = convertBinaryToLong( msdlibBuff+i );;

    if( i4 <= 0x0ffffff6 ) return i4;   // ̃NX^

    // ŏINX^ANX^͍Ȃ
    if( s_cls <= 1 ) return i4;

    // ŏINX^ȂANX^
    while( 1 ) {
        // NX^̏`FbN
        if( ClusterToSector(s_cls)+7 >= BPB_bigTotalSectors ) {
            return 0;
        }
        if( (s_cls>>7) != (s_cls2>>7) ) {
            s_cls2 = s_cls;
            readMicroSD(
                Sec_FAT[0] + (s_cls>>7), (signed char*)msdlibBuff );
        }

        i = (s_cls & 0x0000007f) << 2;
        i4  = convertBinaryToLong( msdlibBuff+i );

        if( i4 == 0x00000000 ) {    // 󂢂Ă邩H
            // ŏINX^0x0fffffff
            msdlibBuff[i+3] = 0x0f;
            msdlibBuff[i+2] = 0xff;
            msdlibBuff[i+1] = 0xff;
            msdlibBuff[i+0] = 0xff;
            for( i=0; i<BPB_NumberOfFATs; i++ ) {
                writeMicroSD(
                    Sec_FAT[i] + (s_cls>>7), (signed char*)msdlibBuff );
            }
            // ݂̃NX^ɍŏINX^Ȃ
            readMicroSD(
                Sec_FAT[0] + (cluster>>7), (signed char*)msdlibBuff );
            i = (cluster & 0x0000007f) << 2;
            msdlibBuff[i+3] = (s_cls>>24) & 0xff;
            msdlibBuff[i+2] = (s_cls>>16) & 0xff;
            msdlibBuff[i+1] = (s_cls>> 8) & 0xff;
            msdlibBuff[i+0] = (s_cls    ) & 0xff;
            for( i=0; i<BPB_NumberOfFATs; i++ ) {
                writeMicroSD(
                    Sec_FAT[i] + (cluster>>7), (signed char*)msdlibBuff );
            }
            // NX^̎QƐNA
            i4 = ClusterToSector( s_cls );
            // C[YR}h́AC[Ỹ[hłȂG[ɂȂ̂ŁA
            // writeőp
            // eraseMicroSD( i4, i4 + BPB_SctorsPerCluster - 1 );
            for( i=0; i<512; i++ ) msdlibBuff[i] = 0;   /* obt@NA   */
            for(i=0; i<BPB_SctorsPerCluster; i++ ) {
                writeMicroSD( i4 + i, (signed char*)msdlibBuff );
            }

            return s_cls;
        }
        s_cls++;
    }
    return 0;
}

/************************************************************************/
/* W[ writeFile                                               */
/* Tv     t@C쐬Aݏ                              */
/* @       char * t@C(8+3`)                              */
/*              unsigned long t@CTCY                            */
/* ߂l       0: 0ȊO:s                                       */
/************************************************************************/
int writeFile( const char *s, unsigned long fileSize )
{
    int  ret = 0, r, i, j;
    char *p ,name[8+3+1+1];
    unsigned long cluster, cluster2, st_cls;
    unsigned long fileSector, sector, i4;

    if( fFileOpen ) {
        // t@CI[v
        ret = 1;
        goto writeFile_Error;
    }

    modeSector = 1;                     // AhXIZN^

    // t@CTCYŏNX^Ő؂グ
    fileSector  = fileSize + (BPB_SctorsPerCluster<<9) - 1;
    fileSector /= (BPB_SctorsPerCluster<<9);
    fileSector *= BPB_SctorsPerCluster;     // NX^̔{ɂ
    fileSize    = fileSector << 9;

    // t@Cl[ϊ
    memset( name, ' ', 8+3 );
    name[11] = '\0';
    for(p = name; *s; s++,p++ ) {
        if( p > name+11 ) {
            ret = 2;
            goto writeFile_Error;
        }
        if( *s == '.' ) p = name + 8, s++;
        if( *s == ',' ) p = name + 8, s++;
        *p = toupper(*s);        /* p̎wg啶ɕϊ */
    }

    // t@C邩`FbN
    cluster = BPB_RootDirCluster;
    ret = 0;
    while( ret == 0 ) {
        sector = ClusterToSector( cluster );

        for( j=0;j<BPB_SctorsPerCluster ; j++ ) {
            // 1NX^̃ZN^ǂݍŃ`FbN
            r = readMicroSD( sector , (signed char*)msdlibBuff );
            if( r != 0 ) {
                ret = 3;
                goto writeFile_Error;
            }
            for( i=0; i<16; i++ ) {
                if( memcmp(msdlibBuff+i*32, name, 11) == 0 ) {
                    ret = 1;    // t@C
                    goto writeFile_FileCechkExit;
                }
            }
            sector++;
        }
        cluster = nextCluster( cluster, 0 );
        if( cluster >= 0x0ffffff8 ) {
            ret = 2;            // t@CȂ
        }
        if( cluster == 0 ) {
            ret = 4;            // eʃI[o[
            goto writeFile_Error;
        }
    }
writeFile_FileCechkExit:

    if( ret == 1 ) {
        // t@CȂ폜

        // t@C폜
        cluster  = (unsigned long)msdlibBuff[i*32+21] << 24;
        cluster |= (unsigned long)msdlibBuff[i*32+20] << 16;
        cluster |= (unsigned long)msdlibBuff[i*32+27] <<  8;
        cluster |= (unsigned long)msdlibBuff[i*32+26];
        msdlibBuff[ i*32+0 ] = 0xe5;  // t@C폜
        r = writeMicroSD( sector, (signed char*)msdlibBuff );
        if( r != 0 ) {
            ret = 11;
            goto writeFile_Error;
        }

        // FAT̈폜
        cluster2  = 0xffffffff;
        while( 1 ) {
            if( (cluster>>7) != (cluster2>>7) ) {
                r = readMicroSD(
                    Sec_FAT[0] + (cluster>>7), (signed char*)msdlibBuff );
                if( r != 0 ) {
                    ret = 12;
                    goto writeFile_Error;
                }
            }
            cluster2 = cluster;
            i = (cluster2 & 0x0000007f) << 2;
            cluster  = convertBinaryToLong( msdlibBuff+i );
            msdlibBuff[i+3] = 0x00;
            msdlibBuff[i+2] = 0x00;
            msdlibBuff[i+1] = 0x00;
            msdlibBuff[i+0] = 0x00;
            if( (cluster >= 0x0ffffff8) ||
                                    ((cluster>>7) != (cluster2>>7)) ) {
                for( i=0; i<BPB_NumberOfFATs; i++ ) {
                    writeMicroSD(
                        Sec_FAT[i]+(cluster2>>7), (signed char*)msdlibBuff );
                    if( r != 0 ) {
                        ret = 12;
                        goto writeFile_Error;
                    }
                }
            }
            if( cluster >= 0x0ffffff8 ) break;
        }
    }

    // t@C쐬Äm

    // t@CTCYAFAT̈m
    cluster  = 2;
    cluster2 = 0xffffffff;
    ret = 0;
    i = 0;              // X^[gNX^;
    while( ret == 0 ) {
        // NX^̏`FbN
        if( ClusterToSector(cluster)+7 >= BPB_bigTotalSectors ) {
            ret = 21;   // ANX^͌Ȃ
            goto writeFile_Error;
        }

        if( (cluster>>7) != (cluster2>>7) ) {
            cluster2 = cluster;
            r = readMicroSD(
                Sec_FAT[0]+(cluster>>7) , (signed char*)msdlibBuff );
            if( r != 0 ) {
                ret = 22;
                goto writeFile_Error;
            }
        }

        j = (cluster & 0x0000007f) << 2;
        i4  = convertBinaryToLong( msdlibBuff+j );
        if( i4 != 0 ) {
            cluster += fileSector / BPB_SctorsPerCluster - 1;   // t@CTCY₷
            i = 0;
        } else {
            i++;
        }
        if( i >= (fileSector/BPB_SctorsPerCluster) ) {
            // ANX^
            st_cls = cluster - i + 1;   // ANX^̐擪
            ret = 1;
            break;
        }
        cluster++;
    }

    // RDE̋󂫂`FbN
    cluster = BPB_RootDirCluster;
    ret = 0;
    while( ret == 0 ) {
        sector = ClusterToSector( cluster );

        for( i=0;i<BPB_SctorsPerCluster ; i++ ) {
            // 1NX^̃ZN^ǂݍŃ`FbN
            r = readMicroSD( sector , (signed char*)msdlibBuff );
            if( r != 0 ) {
                ret = 31;
                goto writeFile_Error;
            }

            for( j=0; j<16; j++ ) {
                if( msdlibBuff[j*32] == 0x00 || msdlibBuff[j*32] == 0xe5 ) {
                    // 󂫗̈@I
                    p = msdlibBuff + j * 32;
                    *p++ = name[ 0];
                    *p++ = name[ 1];
                    *p++ = name[ 2];
                    *p++ = name[ 3];
                    *p++ = name[ 4];
                    *p++ = name[ 5];
                    *p++ = name[ 6];
                    *p++ = name[ 7];
                    *p++ = name[ 8];
                    *p++ = name[ 9];
                    *p++ = name[10];
                    *p++ = 0x20;                                    // 11 
                    *p++ = '\0';                                    // 12
                    *p++ = '\0';                                    // 13
                    *p++ = ((fileMin  <<5)&0xe0) | ((fileSec     )&0x1f);//14
                    *p++ = ((fileHour <<3)&0xf8) | ((fileMin  >>3)&0x07);//15
                    *p++ = ((fileMonth<<5)&0xe0) | ((fileDay     )&0x1f);//16
                    *p++ = ((fileYear <<1)&0xfe) | ((fileMonth>>3)&0x01);//17
                    *p++ = msdlibBuff[j * 32 + 16];                 // 18
                    *p++ = msdlibBuff[j * 32 + 17];                 // 19
                    *p++ = (st_cls  >>16)&0xff;                     // 20
                    *p++ = (st_cls  >>24)&0xff;                     // 21
                    *p++ = msdlibBuff[j * 32 + 14];                 // 22
                    *p++ = msdlibBuff[j * 32 + 15];                 // 23
                    *p++ = msdlibBuff[j * 32 + 16];                 // 24
                    *p++ = msdlibBuff[j * 32 + 17];                 // 25
                    *p++ = (st_cls      )&0xff;                     // 26
                    *p++ = (st_cls  >> 8)&0xff;                     // 27
                    *p++ = (fileSize    )&0xff;                     // 28
                    *p++ = (fileSize>> 8)&0xff;                     // 29
                    *p++ = (fileSize>>16)&0xff;                     // 30
                    *p++ = (fileSize>>24)&0xff;                     // 31
                    r = writeMicroSD( sector , (signed char*)msdlibBuff );
                    if( r != 0 ) {
                        ret = 32;
                        goto writeFile_Error;
                    }
                    goto writeFile_FileMakeExit;
                }
            }
            sector++;
        }
        cluster = nextCluster(
                    cluster, st_cls + fileSector/BPB_SctorsPerCluster );
        if( cluster == 0 ) {
            ret = 33;   // 󂫖
            goto writeFile_Error;
        }
    }
writeFile_FileMakeExit:

    // NX^̈Ȃ
    cluster  = st_cls;
    cluster2 = 0xffffffff;
    ret = 0;
    while( ret == 0 ) {
        if( (cluster>>7) != (cluster2>>7) ) {
            cluster2 = cluster;
            r = readMicroSD(
                Sec_FAT[0]+(cluster>>7) , (signed char*)msdlibBuff );
            if( r != 0 ) {
                ret = 41;
                goto writeFile_Error;
            }
        }
        i = (cluster & 0x0000007f) << 2;
        cluster++;
        if( cluster >= (st_cls+fileSector/BPB_SctorsPerCluster) ) {
            cluster = 0x0fffffff;
            ret = 1;
        }
        msdlibBuff[i+3] = (cluster>>24) & 0xff;
        msdlibBuff[i+2] = (cluster>>16) & 0xff;
        msdlibBuff[i+1] = (cluster>> 8) & 0xff;
        msdlibBuff[i+0] = (cluster    ) & 0xff;

        if( (cluster>>7) != (cluster2>>7) ) {
            for( i=0; i<BPB_NumberOfFATs; i++ ) {
                r = writeMicroSD(
                    Sec_FAT[i] + (cluster2>>7), (signed char*)msdlibBuff );
                if( r != 0 ) {
                    ret = 42;
                    goto writeFile_Error;
                }
            }
        }
    }

    // mۂ̈@NA
    writeSectorStart = ClusterToSector( st_cls );
    writeSectorWork  = writeSectorStart;
    writeSectorEnd   = ClusterToSector(
                        st_cls + fileSector / BPB_SctorsPerCluster ) - 1;

    r = eraseMicroSD( writeSectorStart, writeSectorEnd );
    // G[Ă

    r = microSDProcessStart( writeSectorStart );
    if( r != 0 ) {
        ret = 43;       // }`ubNCg̏@s
        ret = r;
        goto writeFile_Error;
    }

    fFileOpen = 1;      // t@CI[v

    return 0;           // 

writeFile_Error:
    // G[
    if( msdLed ) msdLed = 0x8000;

    return ret;
}

/************************************************************************/
/* W[ convertDecimalToStr                                     */
/* Tv     int^10iɕϊ                               */
/* @       int l                                                  */
/*              int (}CiX܂񂾐)                            */
/*              char* ϊli[z                          */
/* ߂l       Ȃ                                                    */
/*          46s 6̏ꍇ                                 */
/************************************************************************/
void convertDecimalToStr( int value, int keta, signed char *p )
{
    char temp;

    if( keta > 6 ) keta = 6;

    if( value < 0 ) {
        value = -value;
        *p++ = '-';
        keta--;
    }

    p = p + keta;

    while( keta ) {
        p--;
        keta--;
        temp = value % 10;
        temp += '0';
        *p = temp;
        value /= 10;
    }
}
/************************************************************************/
/* W[ convertHexToStr                                         */
/* Tv     int^16iɕϊ                               */
/* @       int l                                                  */
/*              int                                                 */
/*              char* ϊli[z                          */
/* ߂l       Ȃ                                                    */
/*          24s 4̏ꍇ                                 */
/************************************************************************/
void convertHexToStr( unsigned int value, int keta, signed char *p )
{
    char temp;

    if( keta > 4 ) keta = 4;

    p = p + keta;

    while( keta ) {
        p--;
        keta--;
        temp = value & 0x000f;
        if( temp < 10 ) {
            temp += '0';
        } else {
            temp += ('a' - 10);
        }
        *p = temp;
        value >>= 4;
    }
}

/************************************************************************/
/* W[ convertBinaryToStr                                      */
/* Tv     unsigned char^2i̕ɕϊ                    */
/* @       unsigned char l                                        */
/*              int                                                 */
/*              char* ϊli[z                          */
/* ߂l       Ȃ                                                    */
/*          38s 8̏ꍇ                                 */
/************************************************************************/
void convertBinaryToStr( unsigned char value, int keta, signed char *p )
{
    char temp;

    if( keta > 8 ) keta = 8;

    p = p + keta;

    while( keta ) {
        p--;
        keta--;
        temp  = value & 0x0001;
        temp += '0';
        *p = temp;
        value >>= 1;
    }
}

/************************************************************************/
/* W[ getCompileYear                                          */
/* Tv     RpC̔N擾                              */
/* @       Ȃ                                                    */
/* ߂l       N                                                      */
/************************************************************************/
int getCompileYear( const char *p )
{
    int i;

    i = atoi( p + 7 );

    if( i < 1980 || i > 2107 ) i = 2012;

    return i;
}

/************************************************************************/
/* W[ getCompileMonth                                         */
/* Tv     RpČ擾                              */
/* @       Ȃ                                                    */
/* ߂l                                                             */
/************************************************************************/
int getCompileMonth( const char *p )
{
    int i, r;

    for( i=0; i<12; i++ ) {
        r = strncmp( monthStr + i * 3, p, 3 );
        if( r == 0 ) return i + 1;
    }
    return 1;
}

/************************************************************************/
/* W[ getCompileDay                                           */
/* Tv     RpC̓擾                              */
/* @       Ȃ                                                    */
/* ߂l                                                             */
/************************************************************************/
int getCompileDay( const char *p )
{
    int i;

    i = atoi( p + 4 );

    if( i < 1 || i > 31 ) i = 1;

    return i;
}

/************************************************************************/
/* W[ getCompileHour                                          */
/* Tv     RpC̎擾                              */
/* @       Ȃ                                                    */
/* ߂l                                                             */
/************************************************************************/
int getCompileHour( const char *p )
{
    int i;

    i = atoi( p );

    if( i < 0 || i > 23 ) i = 0;

    return i;
}

/************************************************************************/
/* W[ getCompilerMinute                                       */
/* Tv     RpC̕擾                              */
/* @       Ȃ                                                    */
/* ߂l                                                             */
/************************************************************************/
int getCompilerMinute( const char *p )
{
    int i;

    i = atoi( p + 3 );

    if( i < 0 || i > 59 ) i = 0;

    return i;
}

/************************************************************************/
/* W[ getCompilerSecond                                       */
/* Tv     RpC̕b擾                              */
/* @       Ȃ                                                    */
/* ߂l       b                                                      */
/************************************************************************/
int getCompilerSecond( const char *p )
{
    int i;

    i = atoi( p + 6 );

    if( i < 0 || i > 59 ) i = 0;

    return i;
}

/************************************************************************/
/* W[ setDateStamp                                            */
/* Tv     t@CƂ̓tݒ                          */
/* @       NAA                                              */
/* ߂l                                                           */
/************************************************************************/
void setDateStamp( int y, int m, int d )
{
    if( y >= 1980 && y <= 2107 ) {
        fileYear  = y - 1980;
    } else {
        fileYear  = 2012 - 1980;
    }
    if( m >= 1 && m <= 12 ) {
        fileMonth = m;
    } else {
        fileMonth = 1;
    }
    if( d >= 1 && d <= 31 ) {
        fileDay = d;
    } else {
        fileDay = 1;
    }
}

/************************************************************************/
/* W[ setTimeStamp                                            */
/* Tv     t@CƂ̎Ԃݒ                          */
/* @       AAb                                              */
/* ߂l                                                           */
/************************************************************************/
void setTimeStamp( int h, int m, int s )
{
    if( h >= 0 && h <= 23 ) {
        fileHour = h;
    } else {
        fileHour = 0;
    }
    if( m >= 0 && m <= 59 ) {
        fileMin = m;
    } else {
        fileMin = 0;
    }
    if( s >= 0 && s <= 59 ) {
        fileSec = s / 2;
    } else {
        fileSec = 0;
    }
}

/************************************************************************/
/* W[ readMicroSDNumber                                       */
/* Tv     microSDt@Cԍ擾                             */
/* @                                                           */
/* ߂l       -1:G[ 0ȏFl                                     */
/************************************************************************/
int readMicroSDNumber( void )
{
    int ret;

    ret = readMicroSD( BPB_SctorNo, (signed char*)msdlibBuff );
    if( ret != 0 ) return -1;
    ret   = (unsigned char)msdlibBuff[508];
    ret <<= 8;
    ret  |= (unsigned char)msdlibBuff[509];

    return ret;
}

/************************************************************************/
/* W[ writeMicroSDNumber                                      */
/* Tv     microSDɃt@Cԍ                           */
/* @       ޔԍ                                            */
/* ߂l       -1:G[ 0F݊                               */
/************************************************************************/
int writeMicroSDNumber( int number )
{
    int ret;

    // BPBǂݍ
    ret = readMicroSD( BPB_SctorNo, (signed char*)msdlibBuff );
    if( ret != 0 ) return -1;

    // ɐݒ
    msdlibBuff[508] = (unsigned char)(number >> 8);
    msdlibBuff[509] = (unsigned char)(number & 0xff);

    // 
    ret = writeMicroSD( BPB_SctorNo, (signed char*)msdlibBuff );
    if( ret != 0 ) return -1;

    return 0;
}

/************************************************************************/
/* W[ msdPrintf                                               */
/* Tv     microSD@tݏ                           */
/* @       microSDɏޓe@printfƂقړ           */
/* ߂l       0:  1:ݒŏ݂ł                    */
/*              2:ݒ~(t@CN[Y)                        */
/************************************************************************/
int msdPrintf(char _far *format, ...)
{
    volatile va_list argptr;
    volatile char _far *p;
    volatile int ret = 0;
    volatile int i;

    // ݏݏȂ獡͖
    if( msdPrintfMode != 0 ) return 1;

    // obt@I[o[Ȃ獡͖
    if( writeBuffNo == 0 )  {
        if( pWriteBuff >= (msdlibBuff+512) ) return 1;
    } else {
        if( pWriteBuff >= (msdlibBuff2+512) ) return 1;
    }

    // t@CN[ŶŖ
    if( fFileOpen == 0 ) return 2;

    va_start(argptr, format);

    // p[^obt@ɕۑ
    pFormat = msdPrintfBuff_Format;
    for( p=format; *p!='\0'; p++ ) {
        *pFormat++ = *p;
    }
    *pFormat = '\0';

    // obt@ɕۑ
    pPara = msdPrintfBuff_Para;
    for( i=0; i<64; i++ ) {
        *pPara++ = va_arg( argptr, char );
    }

    va_end(argptr);

    // WJJn
    pFormat     = msdPrintfBuff_Format; // ǂݍݐ
    pPara       = msdPrintfBuff_Para;   // p[^ǂݍݐ
    msdPrintfMode = 1;

    return 0;
}

/************************************************************************/
/* W[ microSDPrintfProcess                                    */
/* Tv     microSD msdPrintf֐@                           */
/* @        1msƂɎsĂ                          */
/* ߂l       msdlibMode̒l                                          */
/************************************************************************/
int microSDPrintfProcess( void )
{
    int i, j, loop;

    switch( msdPrintfMode ) {
    case 0:
        // ҂
        break;

    case 1:
        // WJ
        loop = 0;
        while( loop < 3 ) {
            if( *pFormat == '\0' ) {
                msdPrintfMode = 2;
                break;
            }

            switch( *pFormat ) {
            case '%':       // ϊw蕶
                pFormat++;
                loop++;
                j = 0;

                // 
                switch( *pFormat ) {
                case '0':
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                case '8':
                case '9':
                    j = *pFormat - '0';
                    pFormat++;
                    break;
                }

                // ϊw蕶
                switch( *pFormat ) {
                case 'd':
                case 'D':
                    if( j <= 0 ) j = 5;
                    if( j >  6 ) j = 6;
                    convertDecimalToStr(
                        *(int*)pPara, j, (signed char*)pWriteBuff );
                    pFormat++;
                    pPara += 2;
                    pWriteBuff += j;
                    break;
                case 'b':
                case 'B':
                    if( j <= 0 ) j = 8;
                    if( j >  8 ) j = 8;
                    convertBinaryToStr(
                        *pPara, j, (signed char*)pWriteBuff );
                    pFormat++;
                    pPara += 2;
                    pWriteBuff += j;
                    break;
                case 'x':
                case 'X':
                    if( j <= 0 ) j = 4;
                    if( j >  4 ) j = 4;
                    convertHexToStr(
                        *(int*)pPara, j, (signed char*)pWriteBuff );
                    pFormat++;
                    pPara += 2;
                    pWriteBuff += j;
                    break;
                case 'c':
                case 'C':
                    *pWriteBuff = *pPara;
                    pFormat++;
                    pPara += 2;
                    pWriteBuff += 1;
                    break;
                default:
                    break;
                }
                break;
            default:    // ȊO͂̂܂ܑ
                *pWriteBuff++ = *pFormat++;
                break;
            }
        }
        break;

    case 2:
        // obt@mF
        if( writeBuffNo == 0 )  {
            if( pWriteBuff >= (msdlibBuff+512) ) {
                j = (int)(pWriteBuff - msdlibBuff - 512);
                pWriteBuff = msdlibBuff2;
                for( i=0; i<j; i++ ) {
                    *pWriteBuff++ = msdlibBuff[512+i];
                }
                writeBuffNo = 1;
                msdlibBuff[512] = 0xff;
                msdlibBuff[513] = 0xff;

                msdlibWrite = msdlibBuff;
                msdPrintfMode = 3;
            } else {
                msdPrintfMode = 0;
            }
        } else {
            if( pWriteBuff >= (msdlibBuff2+512) ) {
                j = (int)(pWriteBuff - msdlibBuff2 - 512);
                pWriteBuff = msdlibBuff;
                for( i=0; i<j; i++ ) {
                    *pWriteBuff++ = msdlibBuff2[512+i];
                }
                writeBuffNo = 0;
                msdlibBuff2[512] = 0xff;
                msdlibBuff2[513] = 0xff;

                msdlibWrite = msdlibBuff2;
                msdPrintfMode = 3;
            } else {
                msdPrintfMode = 0;
            }
        }
        break;

    case 3:
        // microSD݊Jn

        /* LED_ŏ */
        if( msdLed == 0x4000 ) msdLed += LED_BLINK;

        /* ]̃G[Ȃ`FbN */
        if( msdlibMode == 0 ) {
            if( fFileOpen ) {
                if( msdLed ) msdLed = 0x8000;
                fFileOpen = 0;
                goto microSDPrintfProcess_End;
            }
        }

        /* t@CƂďݎ̏̃`FbN */
        if( fFileOpen ) {
            if( writeSectorWork > writeSectorEnd ) {
                fFileOpen = 0;
                goto microSDPrintfProcess_End;
            }
            writeSectorWork++;
        }

        msdlibCnt = 514;                /* obt@ݐ           */
        s1tic = 0x02;
        u1tbl = 0xfc;                   /* 1M(c݂͊)  */
        msdlibMode = 12;                /* microSDProcess Jn      */

        msdPrintfMode = 0;

        break;
    }

microSDPrintfProcess_End:
    return msdlibMode;
}

/************************************************************************/
/* W[ checkMsdPrintf                                          */
/* Tv     microSD@Ԍݏ̏I`FbN                 */
/*          Ȃ                                                    */
/* ߂l       0: 0ȊOF                                */
/************************************************************************/
int checkMsdPrintf( void )
{
  return msdPrintfMode;
}

#endif
//////////////////////////////////////////////////////////////////////////
// FAT32֌WvO܂                                         //
//////////////////////////////////////////////////////////////////////////

/************************************************************************/
/* end of file                                                          */
/************************************************************************/

/*
o

2011.04.01 Ver.1.00 쐬
2012.03.16 Ver.2.00 SDHCΉȂׂC
2012.04.01 Ver.3.00 FAT32ւ̃t@C݂ɑΉ(FAT12,FAT16,LFN͖Ή)
2013.04.01 Ver.3.10 msdPrintf֐쐬
2014.06.01 Ver.3.11 eraseMicroSDŴװɂȂmicroSD߳Ă
*/
