/****************************************************************************/
/* Ώۃ}CR R8C/38A                                                     */
/* ̧ٓe     printf,scanf֘A                                        */
/* o[W   Ver.1.04                                                     */
/* Date         2016.02.08                                                  */
/* Copyright    Wp}CRJ[[sψ                        */
/****************************************************************************/

/*======================================*/
/* CN[h                         */
/*======================================*/
#include    <stdio.h>
#include    "sfr_r838a.h"               /* R8C/38A SFR̒`t@C    */
#include    "printf_lib.h"              /* printf֘A               */

/*======================================*/
/* V{`                         */
/*======================================*/
#define         SEND_BUFF_SIZE  64      /* Mobt@TCY           */
#define         RECV_BUFF_SIZE  32      /* Mobt@TCY           */
#define         UART0_INT_LEVEL 1       /* M荞ݗD惌xݒ   */

/*======================================*/
/* O[oϐ̐錾                 */
/*======================================*/
/* Mobt@ */
static volatile char    send_buff[SEND_BUFF_SIZE];
static volatile char    *send_w = send_buff;
static volatile char    *send_r = send_buff;
static volatile int     send_count = 0;

/* Mobt@ */
static volatile char    recv_buff[RECV_BUFF_SIZE];
static volatile char    *recv_w = recv_buff;
static volatile char    *recv_r = recv_buff;

/* printf,scanf֌W */
volatile FILE           _iob[4];

/*======================================*/
/* vg^Cv錾                     */
/*======================================*/
int write( int s );
int read( void );
int setSendBuff( char c );
int getSendBuff( char *c );

/************************************************************************/
/* UART0̏Ayprintf֌WUART0Ɋ蓖                       */
/* @ ʐMx                                                      */
/* ߂l Ȃ                                                          */
/************************************************************************/
void init_uart0_printf( int sp )
{
    stdin->_cnt = stdout->_cnt = stdaux->_cnt = stdprn->_cnt = 0;
    stdin->_flag = _IOREAD;
    stdout->_flag = _IOWRT;
    stdaux->_flag = _IORW;
    stdprn->_flag = _IOWRT;

    stdin->_mod = _TEXT;
    stdout->_mod = _TEXT;
    stdaux->_mod = _BIN;
    stdprn->_mod = _TEXT;

    stdin->_func_in = read;
    stdout->_func_in = NULL;
    stdaux->_func_in = read;
    stdprn->_func_in = NULL;

    stdin->_func_out = NULL;
    stdout->_func_out = write;
    stdaux->_func_out = write;
    stdprn->_func_out = NULL;

    /* UART0̐ݒ */
    u0sr = 0x05;                        /* P14=TXD0,P15=RXD0ɐݒ      */
    if( sp == SPEED_4800 ) {
        /* 4800bps u0brg = 2.5MHz / (4800 * 16) - 1 = 31.552 = 32 */
        u0c0 = 0x01;                    /* JEg\[XȂǂ̐ݒ     */
        u0c1 = 0x05;                    /* MM                */
        u0brg = 32;                     /* ʐMx = 4800pbs           */
    } else if( sp == SPEED_9600 ) {
        /* 9600bps u0brg = 20MHz / (9600 * 16) - 1 =129.208 = 129 */
        u0c0 = 0x00;                    /* JEg\[XȂǂ̐ݒ     */
        u0c1 = 0x05;                    /* MM                */
        u0brg = 129;                    /* ʐMx = 9600pbs           */
    } else if( sp == SPEED_19200 ) {
        /* 19200bps u0brg = 20MHz / (19200 * 16) - 1 = 64.104 = 64 */
        u0c0 = 0x00;                    /* JEg\[XȂǂ̐ݒ     */
        u0c1 = 0x05;                    /* MM                */
        u0brg = 64;                     /* ʐMx = 19200pbs          */
    } else if( sp == SPEED_38400 ) {
        /* 38400bps u0brg = 20MHz / (38400 * 16) - 1 = 31.552 = 32 */
        u0c0 = 0x00;                    /* JEg\[XȂǂ̐ݒ     */
        u0c1 = 0x05;                    /* MM                */
        u0brg = 32;                     /* ʐMx = 38400pbs          */
    }
    u0mr = 0x05;                        /* UART0 ް8bit 1įޯ  */
}

/************************************************************************/
/* printfŌĂяo֐                                             */
/* [U[͌Ăяo܂                                         */
/************************************************************************/
int write( int c )
{

// 1Ŋ荞݂gp(main֐ׂ̕Ȃ)
// 0Ŋ荞݂gp(Â炢)
#if 1
    volatile char   put_data;

    if( c == '\n' )  {
        while( !setSendBuff( '\r' ) );
    } else if( c == '\b' ) {
        while( !setSendBuff( '\b' ) );
        while( !setSendBuff( ' ' ) );
    }
    while( !setSendBuff( c ) );

    if( (s0tic & 0x07) == 0 ) {
        getSendBuff( &put_data );
        s0tic = 0x01;                   /* M荞ݗD惌xݒ   */
        put_uart0( put_data );
    }

    return 1;   // TRUE
#else
    if( c == '\n' )  {
        while( put_uart0( '\r' ) == 0 );
    } else if( c == '\b' ) {
        while( put_uart0( '\b' ) == 0 );
        while( put_uart0( ' '  ) == 0 );
    }
    while( put_uart0( c ) == 0 );

    return 1;   // TRUE
#endif
}

/************************************************************************/
/* scanfŌĂяo֐                                              */
/* [U[͌Ăяo܂                                         */
/************************************************************************/
int read( void )
{
    volatile char   c;

    if( recv_r == recv_w ) {
        do {
            /* M҂ */
            while( get_uart0( &c ) != 1 );

            switch( c ) {
                case '\b':  /* obNXy[X */
                    /* obt@ɂȂȂBS͖ */
                    if( recv_r == recv_w ) continue;
                    /* Ȃ߂ */
                    recv_w--;
                    break;
                case '\r':  /* EnterL[ */
                    *recv_w++ = c = '\n';
                    *recv_w++ = '\r';
                    break;
                default:
                    if( recv_w >= recv_buff+RECV_BUFF_SIZE-2 ) continue;
                    *recv_w++ = c;
                    break;
            }
            /* GR[obN ͂ꂽԂ */
            write( c );
        } while( c != '\n' );
    }
    c = *recv_r++;
    if( recv_r == recv_w ) recv_r = recv_w = recv_buff;

    return c;
}

/************************************************************************/
/* Mobt@ɕۑ                                                   */
/* @ i[                                                      */
/* ߂l 0:ۑł 1:ۑ                                       */
/************************************************************************/
int setSendBuff( char c )
{
    int ret= 0;

//    asm( "FCLR I" );                    /* Ŝ̊荞݋֎~           */

    if( send_count < SEND_BUFF_SIZE ) {
        *send_w++ = c;
        if( send_w >= send_buff+SEND_BUFF_SIZE ) send_w = send_buff;
        send_count++;
        ret = 1;
    }

//    asm( "FSET I" );                    /* Ŝ̊荞݋           */

    return ret;
}

/************************************************************************/
/* Mobt@擾                                                 */
/* @ i[镶̃AhX                                        */
/* ߂l 0:f[^Ȃ 1:f[^                                     */
/************************************************************************/
int getSendBuff( char *c )
{
    volatile int    ret = 0;

//    asm( "FCLR I" );                    /* Ŝ̊荞݋֎~           */

    if( send_count ) {
        *c = *send_r++;
        if( send_r >= send_buff+SEND_BUFF_SIZE ) send_r = send_buff;
        send_count--;
        ret = 1;
    }

//    asm( "FSET I" );                    /* Ŝ̊荞݋           */

    return ret;
}

/************************************************************************/
/* URAT0 M荞                                                   */
/* @ Ȃ                                                          */
/* ߂l Ȃ                                                          */
/************************************************************************/
#pragma interrupt   _uart0_trance(vect=17)
void _uart0_trance( void )
{
    volatile char   c;
    volatile int    ret;

    asm( "FSET I" );                    /* ̊荞݃xȏ㋖   */

    ir_s0tic = 0;

    ret = getSendBuff( &c );
    if( ret ) {
        while( put_uart0( c ) == 0 );   /* f[^Ȃ瑗M           */
    } else {
        s0tic = 0x00;                   /* f[^ȂI         */
    }
}

/************************************************************************/
/* PM                                                           */
/* @ Mi[AhX                                          */
/* ߂l -1:MG[ 0:MȂ 1:M *sɊi[            */
/************************************************************************/
int get_uart0( char *s )
{
    volatile int ret = 0;
    volatile int data, i;

    if (ri_u0c1 == 1){                  /* Mf[^H             */
        data = u0rb;
        *s = (char)data;
        ret = 1;
        if( data & 0xf000 ) {           /* G[H                 */
            /* G[͍Đݒ */
            re_u0c1 = 0;
            for( i=0; i<50; i++ );
            re_u0c1 = 1;

            ret = -1;
        }
    }
    return ret;
}

/************************************************************************/
/* Po                                                           */
/* @ Mf[^                                                    */
/* ߂l 0:M̂߁AMł 1:MZbg                   */
/************************************************************************/
int put_uart0( char r )
{
    if(ti_u0c1 == 1) {                  /* Mf[^ȂH             */
        u0tbl = r;
        return 1;
    } else {
        /* ʂȃf[^𑗐M(̃f[^͑MɏI) */
        return 0;
    }
}

/************************************************************************/
/* fgetc(Xg[P͂)Ă΂1͊֐         */
/* @                                                           */
/* ߂l ɓ͂łꍇ́A̕                              */
/*        G[̏ꍇ́AEOF                                           */
/************************************************************************/
int _sget( void ) {

    return 0;

}

/************************************************************************/
/* fgetc(Xg[P͂)Ă΂1o͊֐         */
/* @ o͕                                                      */
/* ߂l :1 ȏ:EOF                                               */
/************************************************************************/
int _sput( int put_data ) {

    return put_data;

}

/************************************************************************/
/* fgetc(Xg[P͂)Ă΂1o͊֐         */
/* @ o͕                                                      */
/* ߂l :1 ȏ:EOF                                               */
/************************************************************************/
int _pput( int put_data ) {

    return put_data;

}

/************************************************************************/
/* end of file                                                          */
/************************************************************************/

/*
o

2010.04.01 Ver.1.00 쐬
2011.03.17 Ver.1.01 M荞݂~܂s̏C(write֐̏C)
2011.04.01 Ver.1.02 ϐvolatileǉ
2015.04.01 Ver.1.03 write֐ɁA荞ݖgp̃vOǉ
2016.02.08 Ver.1.04 write֐setSendBuff֐AMI܂
                    [v悤ɂ
*/
