/****************************************************************************/
/* Ώۃ}CR R8C/38A                                                     */
/* ̧ٓe     tEmicroSD XCb`䃉Cu                    */
/* o[W   Ver.1.01                                                    */
/* Date         2011.04.01                                                  */
/* Copyright    Wp}CRJ[[sψ                        */
/****************************************************************************/

/*======================================*/
/* CN[h                         */
/*======================================*/
#include    "sfr_r838a.h"               /* R8C/38A SFR̒`t@C    */
#include    "switch_lib.h"              /* XCb`䃉Cu       */

/*======================================*/
/* 萔ݒ                             */
/*======================================*/
#define     SWITCH_BIT              5   /* XCb`̐                 */
#define     SWITCH_INTERVAL         10  /* XCb`C^[o 1ms */
#define     SWITCH_ON_COUNT         3   /* ONƔf܂ł̉       */
                                        /* SWITCH_INTERVAL *            */
                                        /*         SWITCH_ON_COUNT [ms] */
#define     SWITCH_REPEAT_INTERVAL  50  /* ONĂ߰Ă܂ł̎*/
                                        /* SWITCH_INTERVAL *            */
                                        /*  SWITCH_REPEAT_INTERVAL [ms] */
#define     SWITCH_REPEAT_COUNT     5   /* s[gԊu                 */
                                        /* SWITCH_INTERVAL *            */
                                        /*     SWITCH_REPEAT_COUNT [ms] */

/*======================================*/
/* O[oϐ̐錾                 */
/*======================================*/
static volatile int     iSwitchIntervalCount;
                                        /* 񂲂Ƃɏ邩̶   */

/* 1bitƂ̃L[ */
struct {
    int     mode;                       /* XCb`[hNop       */
    int     time;                       /* MĂ鎞         */
    int     flag;                       /* "0""1""1"ɂȂ          */
    int     count;                      /* JEg                     */
} static volatile sw_data[ SWITCH_BIT ];

/************************************************************************/
/* W[ initSwitch                                              */
/* Tv     XCb`֘Aϐ                                  */
/*          Ȃ                                                    */
/* ߂l       Ȃ                                                    */
/************************************************************************/
void initSwitch( void )
{
    volatile int i;

    iSwitchIntervalCount = 0;
    pur1                |= 0x0c;        /* 3:P5_4`P5_7 vAbvON    */
                                        /* 2:P5_0`P5_3 vAbvON    */
    /* XCb` */
    for( i=0; i<SWITCH_BIT; i++ ) {
        sw_data[i].mode     = 0;
        sw_data[i].time     = 0;
        sw_data[i].flag     = 0;
        sw_data[i].count    = 0;
    }
}

/************************************************************************/
/* W[ getSwNow                                                */
/* Tv     XCb`ݏԎ擾                                    */
/*          Ȃ                                                    */
/* ߂l       unsigned char XCb`l                                */
/************************************************************************/
unsigned char getSwNow( void )
{
/*
XCb`̓̓|[gςꍇ́Å֐ύX܂B
bit0l߂Ĕzu悤ɂ܂B
݂̐ݒ bit  7    6    5    4    3    2    1    0
                --  --  --  P5_7 P5_3 P5_2 P5_1 P5_0
*/
    volatile unsigned char sw;

    pd5 &= 0x70;                        /* LCDƌp̒[q͂ɐݒ  */

    sw  = (~p5 & 0x80) >> 3;            /* P5_7ǂݍ                 */
    sw |= (~p5 & 0x0f);                 /* P5_3`P5_0ǂݍ           */

    pd5 |= 0x0f;                        /* LCDƌp̒[qo͂ɐݒ  */

    return sw;
}

/************************************************************************/
/* W[ getSwFlag                                               */
/* Tv     XCb`tOԎ擾                                  */
/*          }XNl                                                */
/* ߂l       unsigned char XCb`l                                */
/************************************************************************/
unsigned char getSwFlag( unsigned char flag )
{
    volatile unsigned char ret;

    switch( flag ) {
    case SW_4:
        ret = sw_data[4].flag;
        sw_data[4].flag = 0;
        break;
    case SW_3:
        ret = sw_data[3].flag;
        sw_data[3].flag = 0;
        break;
    case SW_2:
        ret = sw_data[2].flag;
        sw_data[2].flag = 0;
        break;
    case SW_1:
        ret = sw_data[1].flag;
        sw_data[1].flag = 0;
        break;
    case SW_0:
        ret = sw_data[0].flag;
        sw_data[0].flag = 0;
        break;
    }
    return ret;
}

/************************************************************************/
/* W[ switchProcess                                           */
/* Tv     XCb`                                            */
/*          Ȃ                                                    */
/* ߂l       Ȃ                                                    */
/************************************************************************/
void switchProcess( void )
{
    volatile int            i;
    volatile unsigned char  sw;

    /* Ԋũ`FbN */
    iSwitchIntervalCount++;
    if( iSwitchIntervalCount < SWITCH_INTERVAL ) return;

    iSwitchIntervalCount = 0;
    sw = getSwNow();

    /* XCb`̃rbgɏ */
    for( i=0; i<SWITCH_BIT; i++ ) {

        switch( sw_data[i].mode ) {
        case 0:
            /* ON̔ */
            if( sw & 0x01 ) {
                sw_data[i].time++;
                if( sw_data[i].time >= SWITCH_ON_COUNT ) {
                    sw_data[i].mode = 1;
                    sw_data[i].count++;
                    sw_data[i].flag = 1;
                    sw_data[i].time = 0;
                }
            } else {
                sw_data[i].time = 0;
            }
            break;

        case 1:
            /* L[s[g̔ */
            if( sw & 0x01 ) {
                sw_data[i].time++;
                if( sw_data[i].time >= SWITCH_REPEAT_INTERVAL ) {
                    sw_data[i].mode = 2;
                    sw_data[i].count++;
                    sw_data[i].flag = 1;
                    sw_data[i].time = 0;
                }
            } else {
                sw_data[i].mode = 0;
                sw_data[i].time = 0;
            }
            break;

        case 2:
            /* L[s[gAԊuŃtOnmɂ锻 */
            if( sw & 0x01 ) {
                sw_data[i].time++;
                if( sw_data[i].time >= SWITCH_REPEAT_COUNT ) {
                    sw_data[i].count++;
                    sw_data[i].flag = 1;
                    sw_data[i].time = 0;
                }
            } else {
                sw_data[i].mode = 0;
                sw_data[i].time = 0;
            }
            break;
        }

        sw >>= 1;
    }
}

/************************************************************************/
/* end of file                                                          */
/************************************************************************/

/*
o

2011.04.01 Ver.1.00 쐬
2023.08.14 Ver.1.01 getSwNow֐́upd5 &= 0xf0;vu0x70vɕύX
*/
