library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

entity mdrive2 is
port ( CLK    : in std_logic;
       PWM    : in std_logic;
		 CWCCW  : in std_logic;
		 m1     : out std_logic;
		 m2     : out std_logic;
		 m3     : out std_logic;
		 m4     : out std_logic);
end mdrive2;

architecture Behavioral of mdrive2 is

signal PWMA   :  std_logic;
signal PWMB   :  std_logic;
signal PWMP   :  std_logic;
signal PWMQ   :  std_logic;
signal ADD : std_logic_vector(12 downto 0);
signal ACE : std_logic;
signal ADC : std_logic_vector(12 downto 0);
signal ACD : std_logic;

begin

--8MHz=1/0.000000125s > 50us=1/0.000025s ==400count

process(CLK,PWM)--オ肪xA肪g`𐶐
begin
if (PWM = '0') then
   ADD <= "0000000000000";
    elsif (CLK'event and CLK='1') then
    ADD <= ADD+'1';
end if;
end process;

process(ADD,PWM)
begin
if (ADD > "0000110001111")then
	ACE <= '1';
	else
	ACE <= '0';
end if;
end process;

PWMQ <= ACE and PWM;
PWMB <= PWMQ;

-----------------------------------

process(PWM,CLK)--オ肪A肪xg`𐶐
begin
if (PWM = '1') then
   ADC <= "0000000000000";
    elsif (CLK'event and CLK='1') then
    ADC <= ADC+'1';
end if;
end process;

process(ADC,PWM)
begin
if (ADC > "0000110001111" ) then
   ACD <= '0';
	else
	ACD <= '1';
end if;
end process;

PWMP <= ACD or PWM;
PWMA <= PWMP;

-----------------------------HubWɐڑ
process(CWCCW,PWMA,PWMB)
begin
if(CWCCW = '0')then
 m1 <= PWMB;
 m2 <= '0';
 m3 <= '0';
 m4 <= PWMA;
else
 m1 <= '0';
 m2 <= PWMB;
 m3 <= PWMA;
 m4 <= '0';
end if;
end process;

end Behavioral;